/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.gltrace.state.transforms;

import org.eclipse.andmore.gltrace.state.IGLProperty;
import org.eclipse.andmore.gltrace.state.transforms.IGLPropertyAccessor;
import org.eclipse.andmore.gltrace.state.transforms.IPredicate;
import org.eclipse.andmore.gltrace.state.transforms.IStateTransform;

public class PropertyChangeTransform
implements IStateTransform {
    private final IGLPropertyAccessor mAccessor;
    private final Object mNewValue;
    private final IPredicate mPredicate;
    private Object mOldValue;

    PropertyChangeTransform(IGLPropertyAccessor accessor, Object newValue) {
        this(accessor, newValue, null);
    }

    public PropertyChangeTransform(IGLPropertyAccessor accessor, Object newValue, IPredicate predicate) {
        this.mAccessor = accessor;
        this.mNewValue = newValue;
        this.mPredicate = predicate;
        this.mOldValue = null;
    }

    @Override
    public void apply(IGLProperty state) {
        IGLProperty property = this.mAccessor.getProperty(state);
        assert (this.mOldValue == null) : "Transform cannot be applied multiple times";
        if (this.mPredicate != null && !this.mPredicate.apply(property.getValue())) {
            return;
        }
        if (property == null) {
            throw new RuntimeException("No such property: " + this.mAccessor.getPath());
        }
        this.mOldValue = property.getValue();
        property.setValue(this.mNewValue);
    }

    @Override
    public void revert(IGLProperty state) {
        if (this.mOldValue != null) {
            IGLProperty property = this.mAccessor.getProperty(state);
            property.setValue(this.mOldValue);
            this.mOldValue = null;
        }
    }

    @Override
    public IGLProperty getChangedProperty(IGLProperty state) {
        if (this.mPredicate != null) {
            Object value;
            Object object = value = this.mOldValue == null ? this.mNewValue : this.mOldValue;
            if (!this.mPredicate.apply(value)) {
                return null;
            }
        }
        return this.mAccessor.getProperty(state);
    }
}

