/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.hierarchyviewer;

import com.android.hierarchyviewerlib.HierarchyViewerDirector;
import com.android.hierarchyviewerlib.device.IHvDevice;
import com.android.hierarchyviewerlib.models.Window;
import org.eclipse.andmore.hierarchyviewer.HierarchyViewerPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public class HierarchyViewerPluginDirector
extends HierarchyViewerDirector {
    private ISchedulingRule mSchedulingRule = new ISchedulingRule(){

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    };

    public static HierarchyViewerDirector createDirector() {
        sDirector = new HierarchyViewerPluginDirector();
        return sDirector;
    }

    public void executeInBackground(String taskName, final Runnable task) {
        Job job = new Job(taskName){

            protected IStatus run(IProgressMonitor monitor) {
                task.run();
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.setRule(this.mSchedulingRule);
        job.schedule();
    }

    public String getAdbLocation() {
        return HierarchyViewerPlugin.getPlugin().getPreferenceStore().getString("org.eclipse.andmore.hierarchyviewer.adb");
    }

    public void loadViewTreeData(Window window) {
        IWorkbenchWindow[] windows;
        super.loadViewTreeData(window);
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = HierarchyViewerPlugin.getPlugin().getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow currentWindow = iWorkbenchWindowArray[n2];
            IWorkbenchPage page = currentWindow.getActivePage();
            if (page.getPerspective().getId().equals("org.eclipse.andmore.hierarchyviewer.TreeViewPerspective")) {
                try {
                    IViewPart part = page.findView("org.eclipse.andmore.hierarchyviewer.views.PropertyView");
                    if (part != null) {
                        page.showView("org.eclipse.andmore.hierarchyviewer.views.PropertyView");
                    }
                }
                catch (PartInitException partInitException) {}
            }
            ++n2;
        }
    }

    public void loadPixelPerfectData(IHvDevice device) {
        IWorkbenchWindow[] windows;
        super.loadPixelPerfectData(device);
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = HierarchyViewerPlugin.getPlugin().getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage page = window.getActivePage();
            if (page.getPerspective().getId().equals("org.eclipse.andmore.hierarchyviewer.PixelPerfectPespective")) {
                try {
                    IViewPart part = page.findView("org.eclipse.andmore.hierarchyviewer.views.PixelPerfectTreeView");
                    if (part != null) {
                        page.showView("org.eclipse.andmore.hierarchyviewer.views.PixelPerfectTreeView");
                    }
                }
                catch (PartInitException partInitException) {}
            }
            ++n2;
        }
    }
}

