/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.ndk.internal;

import java.io.File;
import java.util.Map;
import org.eclipse.andmore.ndk.internal.Activator;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.TemplateEngine;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class NdkManager {
    public static final String NDK_LOCATION = "ndkLocation";
    public static final String LIBRARY_NAME = "libraryName";

    public static String getNdkLocation() {
        return Activator.getDefault().getPreferenceStore().getString(NDK_LOCATION);
    }

    public static boolean isNdkLocationValid() {
        String location = NdkManager.getNdkLocation();
        if (location.length() == 0) {
            return false;
        }
        return NdkManager.isValidNdkLocation(location);
    }

    public static boolean isValidNdkLocation(String location) {
        File dir = new File(location);
        if (!dir.isDirectory()) {
            return false;
        }
        return new File(dir, "ndk-build").isFile();
    }

    public static void addNativeSupport(IProject project, Map<String, String> templateArgs, IProgressMonitor monitor) throws CoreException {
        TemplateCore template = TemplateEngine.getDefault().getTemplateById("AddNdkSupport");
        Map valueStore = template.getValueStore();
        valueStore.put("projectName", project.getName());
        valueStore.putAll(templateArgs);
        template.executeTemplateProcesses(monitor, false);
        project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
    }
}

