/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.android.manager;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.sequoyah.localization.android.IAndroidLocalizationSchemaConstants;
import org.eclipse.sequoyah.localization.android.manager.NodeManager;
import org.eclipse.sequoyah.localization.tools.datamodel.LocalizationFile;
import org.eclipse.sequoyah.localization.tools.datamodel.LocalizationFileBean;
import org.eclipse.sequoyah.localization.tools.datamodel.StringLocalizationFile;
import org.eclipse.sequoyah.localization.tools.datamodel.node.NodeComment;
import org.eclipse.sequoyah.localization.tools.datamodel.node.StringNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringNodeManager
extends NodeManager
implements IAndroidLocalizationSchemaConstants {
    @Override
    public void loadFile(LocalizationFileBean localizationFileBean, LocalizationFile localizationFile) {
        localizationFileBean.setStringNodes(((StringLocalizationFile)localizationFile).getStringNodes());
    }

    @Override
    public void updateLocalizationFileContent(Document document, ArrayList<StringNode> arrayList) {
        NodeList nodeList = document.getElementsByTagName("string");
        String string = null;
        String string2 = null;
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node;
            Object object;
            Element element = (Element)nodeList.item(n);
            string = element.getAttributeNode("name").getNodeValue();
            String string3 = null;
            if (element.hasChildNodes()) {
                object = element.getChildNodes();
                int n2 = 0;
                while (n2 < object.getLength()) {
                    node = object.item(n2);
                    if (node.getNodeType() == 8) {
                        string3 = node.getNodeValue();
                    }
                    ++n2;
                }
            }
            object = element.getFirstChild();
            StringBuffer stringBuffer = new StringBuffer();
            this.getStringByNodes(stringBuffer, (Node)object);
            string2 = stringBuffer.toString();
            element.toString();
            node = new StringNode(string, string2);
            if (string3 != null) {
                NodeComment nodeComment = new NodeComment();
                nodeComment.setComment(string3);
                node.setNodeComment(nodeComment);
            }
            arrayList.add((StringNode)node);
            ++n;
        }
    }

    @Override
    public void createFile(Document document, Element element, LocalizationFile localizationFile) {
        for (StringNode stringNode : ((StringLocalizationFile)localizationFile).getStringNodes()) {
            this.addSingleEntry(document, element, stringNode);
        }
    }

    public void addSingleEntry(Document document, Element element, StringNode stringNode) {
        Element element2 = document.createElement("string");
        element2.setAttribute("name", stringNode.getKey());
        element2.appendChild(document.createTextNode(stringNode.getValue()));
        this.createOrUpdateComment(document, stringNode, element2);
        element.appendChild(element2);
    }

    @Override
    public void updateFile(LocalizationFile localizationFile, Map<String, StringNode> map) {
        for (StringNode stringNode : ((StringLocalizationFile)localizationFile).getStringNodes()) {
            map.put(stringNode.getKey(), stringNode);
        }
    }
}

