/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.localization.editor.model.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.localization.editor.datatype.CellInfo;
import org.eclipse.sequoyah.localization.editor.datatype.RowInfo;
import org.eclipse.sequoyah.localization.editor.datatype.RowInfoLeaf;
import org.eclipse.sequoyah.localization.editor.i18n.Messages;
import org.eclipse.sequoyah.localization.editor.model.StringEditorPart;
import org.eclipse.sequoyah.localization.editor.model.operations.EditorOperation;

public class EditCellOperation
extends EditorOperation {
    private final String key;
    private final String column;
    private final CellInfo oldValue;
    private final CellInfo newValue;
    private final RowInfo rowInfo;

    public EditCellOperation(String string, String string2, CellInfo cellInfo, CellInfo cellInfo2, StringEditorPart stringEditorPart, RowInfo rowInfo) {
        super(Messages.EditCellOperation_0, stringEditorPart);
        this.key = string;
        this.column = string2;
        this.oldValue = cellInfo;
        this.newValue = cellInfo2;
        this.rowInfo = rowInfo;
    }

    public IStatus execute(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        return this.redo(iProgressMonitor, iAdaptable);
    }

    public IStatus redo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        if (this.newValue != null && this.newValue.getPosition() >= 0) {
            this.getModel().addCell(this.newValue, this.key, this.column, this.newValue.getPosition(), true);
        } else {
            this.getModel().addCell(this.newValue, this.key, this.column);
        }
        if (this.newValue != null && !this.newValue.isDirty()) {
            this.newValue.setDirty(true);
        }
        try {
            if (this.newValue == null || this.newValue != null && this.newValue.getValue() == null) {
                if (this.newValue.getPosition() >= 0) {
                    this.getEditorInput().removeCell(this.key, this.column, this.newValue.getPosition());
                } else {
                    this.getEditorInput().removeCell(this.key, this.column);
                }
            } else if (this.rowInfo instanceof RowInfoLeaf) {
                RowInfoLeaf rowInfoLeaf = (RowInfoLeaf)this.rowInfo;
                if (rowInfoLeaf.getParent() == null) {
                    this.getEditorInput().setValue(this.column, this.key, this.newValue.getValue());
                } else {
                    this.getEditorInput().setValue(this.column, this.key, this.newValue.getValue(), rowInfoLeaf.getPosition());
                }
            } else {
                this.getEditorInput().setValue(this.column, this.key, this.newValue.getValue());
            }
        }
        catch (SequoyahException sequoyahException) {
            BasePlugin.logError((String)("Error editing cell value: (" + this.column + ", " + this.key + ") =" + this.newValue != null ? this.newValue.getValue() : null), (Throwable)sequoyahException);
        }
        this.getEditor().fireDirtyPropertyChanged();
        this.getEditor().getEditorViewer().update((Object)this.rowInfo, null);
        if (this.rowInfo instanceof RowInfoLeaf && ((RowInfoLeaf)this.rowInfo).getParent() != null) {
            this.getEditor().getEditorViewer().update((Object)((RowInfoLeaf)this.rowInfo).getParent(), null);
        }
        return Status.OK_STATUS;
    }

    public IStatus undo(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
        if (this.getModel().getRow(this.rowInfo.getKey()) == null) {
            if (this.rowInfo instanceof RowInfoLeaf) {
                this.getModel().addRow(((RowInfoLeaf)this.rowInfo).getParent());
            }
            this.getModel().addRow(this.rowInfo);
            this.getEditor().refresh();
        }
        if (this.oldValue != null && this.oldValue.getPosition() >= 0 || this.newValue != null && this.newValue.getPosition() >= 0) {
            this.getModel().addCell(this.oldValue, this.key, this.column, this.oldValue != null ? this.oldValue.getPosition() : (this.newValue != null ? this.newValue.getPosition() : -1), true);
        } else {
            this.getModel().addCell(this.oldValue, this.key, this.column);
        }
        if (this.oldValue != null && !this.oldValue.isDirty()) {
            this.oldValue.setDirty(true);
        }
        try {
            if (this.oldValue != null && this.oldValue.getValue() != null) {
                if (this.rowInfo instanceof RowInfoLeaf) {
                    RowInfoLeaf rowInfoLeaf = (RowInfoLeaf)this.rowInfo;
                    if (rowInfoLeaf.getParent() == null) {
                        this.getEditorInput().setValue(this.column, this.key, this.oldValue.getValue());
                    } else {
                        this.getEditorInput().setValue(this.column, this.key, this.oldValue.getValue(), rowInfoLeaf.getPosition());
                    }
                } else {
                    this.getEditorInput().setValue(this.column, this.key, this.oldValue.getValue());
                }
            } else if (this.rowInfo instanceof RowInfoLeaf) {
                RowInfoLeaf rowInfoLeaf = (RowInfoLeaf)this.rowInfo;
                if (rowInfoLeaf.getParent() == null) {
                    this.getEditorInput().removeCell(this.key, this.column);
                } else {
                    this.getEditorInput().removeCell(this.key, this.column, rowInfoLeaf.getPosition());
                }
            } else {
                this.getEditorInput().removeCell(this.key, this.column);
            }
        }
        catch (SequoyahException sequoyahException) {
            BasePlugin.logError((String)("Error undoing cell edition: (" + this.column + ", " + this.key + ") =" + this.oldValue != null ? this.oldValue.getValue() : null), (Throwable)sequoyahException);
        }
        this.getEditor().fireDirtyPropertyChanged();
        this.getEditor().getEditorViewer().update((Object)this.rowInfo, null);
        if (this.rowInfo instanceof RowInfoLeaf && ((RowInfoLeaf)this.rowInfo).getParent() != null) {
            this.getEditor().getEditorViewer().update((Object)((RowInfoLeaf)this.rowInfo).getParent(), null);
        }
        return Status.OK_STATUS;
    }
}

