/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.vnc.vncviewer.network;

import java.io.DataInput;
import org.eclipse.sequoyah.vnc.protocol.lib.exceptions.ProtocolException;
import org.eclipse.sequoyah.vnc.utilities.logger.Logger;

public class PixelFormat {
    private int bitsPerPixel;
    private int depth;
    private int bigEndianFlag;
    private int trueColourFlag;
    private int redMax;
    private int greenMax;
    private int blueMax;
    private int redShift;
    private int greenShift;
    private int blueShift;
    private static int paddingSize = 3;

    public void getPixelFormat(DataInput dataInput) throws ProtocolException {
        try {
            this.bitsPerPixel = dataInput.readUnsignedByte();
            this.depth = dataInput.readUnsignedByte();
            this.bigEndianFlag = dataInput.readUnsignedByte();
            this.trueColourFlag = dataInput.readUnsignedByte();
            this.redMax = dataInput.readUnsignedShort();
            this.greenMax = dataInput.readUnsignedShort();
            this.blueMax = dataInput.readUnsignedShort();
            this.redShift = dataInput.readUnsignedByte();
            this.greenShift = dataInput.readUnsignedByte();
            this.blueShift = dataInput.readUnsignedByte();
            byte[] byArray = new byte[paddingSize];
            dataInput.readFully(byArray);
        }
        catch (Exception exception) {
            Logger.log(PixelFormat.class).error("Pixel Format read error: " + exception.getMessage());
            throw new ProtocolException("Pixel Format read error.");
        }
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getBigEndianFlag() {
        return this.bigEndianFlag;
    }

    public int getTrueColourFlag() {
        return this.trueColourFlag;
    }

    public int getRedMax() {
        return this.redMax;
    }

    public int getGreenMax() {
        return this.greenMax;
    }

    public int getBlueMax() {
        return this.blueMax;
    }

    public int getRedShift() {
        return this.redShift;
    }

    public int getGreenShift() {
        return this.greenShift;
    }

    public int getBlueShift() {
        return this.blueShift;
    }
}

