/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.workflow.generators.pdf;

import java.io.InputStream;
import java.util.Objects;
import org.eclipse.sw360.antenna.attribution.document.core.TemplateBundle;

public class BasicPDFTemplateBundle
implements TemplateBundle {
    private static final String TITLE_TEMPLATE = "/templates/basic_title.pdf";
    private static final String COPYRIGHT_TEMPLATE = "/templates/basic_copyright.pdf";
    private static final String CONTENT_TEMPLATE = "/templates/basic_content.pdf";
    private static final String BACKPAGE_TEMPLATE = "/templates/basic_back.pdf";

    public String key() {
        return "basic-pdf-template";
    }

    public InputStream loadTitleTemplate() {
        return this.loadFromClassPath(TITLE_TEMPLATE);
    }

    public InputStream loadCopyrightTemplate() {
        return this.loadFromClassPath(COPYRIGHT_TEMPLATE);
    }

    public InputStream loadContentTemplate() {
        return this.loadFromClassPath(CONTENT_TEMPLATE);
    }

    public InputStream loadBackPageTemplate() {
        return this.loadFromClassPath(BACKPAGE_TEMPLATE);
    }

    private InputStream loadFromClassPath(String resource) {
        InputStream resourceAsStream = BasicPDFTemplateBundle.class.getResourceAsStream(resource);
        Objects.requireNonNull(resourceAsStream, "Unable to load resource for '" + resource + "'. Maybe the name is wrong or the packaging?");
        return resourceAsStream;
    }
}

