/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.attribution.document.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.eclipse.sw360.antenna.api.exceptions.ExecutionException;
import org.eclipse.sw360.antenna.attribution.document.core.DocumentValues;
import org.eclipse.sw360.antenna.attribution.document.core.Templates;
import org.eclipse.sw360.antenna.attribution.document.core.model.ArtifactAndLicense;
import org.eclipse.sw360.antenna.attribution.document.core.model.LicenseInfo;
import org.eclipse.sw360.antenna.attribution.document.utils.PDFWriterUtils;
import org.eclipse.sw360.antenna.attribution.document.utils.TemplateLoaderUtil;
import rst.pdfbox.layout.elements.ControlElement;
import rst.pdfbox.layout.elements.Document;
import rst.pdfbox.layout.elements.Element;
import rst.pdfbox.layout.elements.Paragraph;
import rst.pdfbox.layout.text.Alignment;
import rst.pdfbox.layout.text.Position;
import rst.pdfbox.layout.text.TextFlow;

public class AttributionDocumentGeneratorImpl {
    private static final String PARAGRAPH_TEXT = "The %s utilizes third-party software components. This attribution document lists these software components and their licenses.";
    private static final String PARAGRAPH_MARKUP = "Components are identified by {color:#0000EE}{link[https://github.com/package-url/purl-spec]}package URL (purl){link}{color:#000000}.";
    private final String documentName;
    private final File workingDir;
    private final String templateKey;
    private final DocumentValues values;

    public AttributionDocumentGeneratorImpl(String documentName, File workingDir, String templateKey, DocumentValues values) {
        this.documentName = documentName;
        this.workingDir = workingDir;
        this.templateKey = templateKey;
        this.values = values;
    }

    public File generate(List<ArtifactAndLicense> artifacts, File cover, File copyright, File content, File back) {
        try (Templates templates = TemplateLoaderUtil.load(cover, copyright, content, back);){
            File file = this.generate(artifacts, templates);
            return file;
        }
    }

    public File generate(List<ArtifactAndLicense> artifacts) {
        try (Templates templates = TemplateLoaderUtil.load(this.templateKey);){
            File file = this.generate(artifacts, templates);
            return file;
        }
    }

    private File generate(List<ArtifactAndLicense> artifacts, Templates templates) {
        File title = this.writeTitle(templates);
        File copyright = this.writeCopyright(templates);
        File backPage = this.writeBackPage(templates.getBackPage());
        File artifactPages = this.writeArtifacts(templates, artifacts, templates.getContent());
        File intermediateDoc = this.mergePages(title, copyright, artifactPages, backPage);
        return this.postProcess(templates, intermediateDoc, this.documentName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File postProcess(Templates templates, File intermediateDoc, String fileName) {
        try (PDDocument pdDocument = PDDocument.load((File)intermediateDoc);){
            int allPages = pdDocument.getPages().getCount();
            PDFont font = templates.loadSansFont(pdDocument);
            for (int i = 1; i < allPages; ++i) {
                PDPage page = pdDocument.getPage(i);
                float pageWidth = page.getMediaBox().getWidth();
                try (PDPageContentStream contents = new PDPageContentStream(pdDocument, page, PDPageContentStream.AppendMode.APPEND, false);){
                    this.writeCopyRightFooter(font, pageWidth, contents);
                    this.writePageNumber(font, pageWidth, contents, i + 1 + "/" + allPages);
                    continue;
                }
            }
            File out = new File(this.workingDir, fileName);
            pdDocument.save(out);
            File file = out;
            return file;
        }
        catch (IOException e) {
            throw new ExecutionException("Post process failed", (Throwable)e);
        }
    }

    private File writeArtifacts(Templates templates, List<ArtifactAndLicense> artifacts, PDDocument template) {
        PDFont sansFont = templates.loadSansFont(template);
        PDFont italicFont = templates.loadSansItalicFont(template);
        PDFont boldFont = templates.loadSansBoldFont(template);
        PDFont boldItalicFont = templates.loadBoldItalicFont(template);
        try {
            Document document = new Document(40.0f, 60.0f, 80.0f, 80.0f);
            document.add((Element)this.createParagraph(String.format("The %s utilizes third-party software components. This attribution document lists these software components and their licenses.%n", this.values.getProductName()), String.format("Components are identified by {color:#0000EE}{link[https://github.com/package-url/purl-spec]}package URL (purl){link}{color:#000000}.%n%n", new Object[0]), 10, sansFont, boldFont, italicFont, boldItalicFont));
            for (ArtifactAndLicense artifact : artifacts) {
                document.add((Element)this.createParagraph(artifact, 10, sansFont, boldFont, italicFont, boldItalicFont));
            }
            this.writeLicenseText(document, artifacts, 15, sansFont, boldFont, italicFont, boldItalicFont);
            File file = new File(this.workingDir, "intermediate.artifacts.pdf");
            this.doSave(document, file);
            return this.doOverlay(file, template, "artifacts.pdf");
        }
        catch (IOException e) {
            throw new ExecutionException("Failed to write artifact and licenses", (Throwable)e);
        }
    }

    private Document writeLicenseText(Document document, List<ArtifactAndLicense> artifacts, int size, PDFont sansFont, PDFont boldFont, PDFont italicFont, PDFont boldItalicFont) throws IOException {
        Map<String, LicenseInfo> licenses = AttributionDocumentGeneratorImpl.extractUniqueLicenses(artifacts);
        List<LicenseInfo> sortedLicenses = AttributionDocumentGeneratorImpl.sortByTitle(licenses);
        for (LicenseInfo license : sortedLicenses) {
            document.add((Element)ControlElement.NEWPAGE);
            Paragraph p = new Paragraph();
            p.addMarkup(String.format("{anchor:%s}*%s*{anchor} %n%n", license.getKey(), license.getTitle()), (float)size, sansFont, boldFont, italicFont, boldItalicFont);
            p.addText(license.getText(), 10.0f, sansFont);
            document.add((Element)p);
        }
        return document;
    }

    private Paragraph createParagraph(ArtifactAndLicense artifact, int size, PDFont sansFont, PDFont boldFont, PDFont italicFont, PDFont boldItalicFont) throws IOException {
        Paragraph p = new Paragraph();
        if (artifact.getPurl().isPresent()) {
            p.addMarkup(String.format("*Package URL:* %s%n", artifact.getPurl().get()), (float)size, sansFont, boldFont, italicFont, boldItalicFont);
        }
        if (artifact.getFilename() != null && !artifact.getFilename().isEmpty()) {
            p.addMarkup(String.format("*Filename:* %s%n", artifact.getFilename()), (float)size, sansFont, boldFont, italicFont, boldItalicFont);
        }
        if (artifact.getCopyrightStatement().isPresent()) {
            p.addMarkup(String.format("*Copyright:* %s%n", artifact.getCopyrightStatement().get()), (float)size, sansFont, boldFont, italicFont, boldItalicFont);
        }
        p.addMarkup("*Licenses:*", (float)size, sansFont, boldFont, italicFont, boldItalicFont);
        for (LicenseInfo license : artifact.getLicenses()) {
            p.addMarkup(String.format("%n- {color:#0000EE}{link[#%s]}%s{link}{color:#000000}", license.getKey(), license.getShortName()), (float)size, sansFont, boldFont, italicFont, boldItalicFont);
        }
        p.addText("\n\n", (float)size, sansFont);
        return p;
    }

    private Paragraph createParagraph(String text, String markUp, int size, PDFont sansFont, PDFont boldFont, PDFont italicFont, PDFont boldItalicFont) throws IOException {
        Paragraph p = new Paragraph();
        p.addText(text, (float)size, sansFont);
        p.addMarkup(markUp, (float)size, sansFont, boldFont, italicFont, boldItalicFont);
        return p;
    }

    private static List<LicenseInfo> sortByTitle(Map<String, LicenseInfo> licenses) {
        ArrayList<LicenseInfo> list = new ArrayList<LicenseInfo>(licenses.values());
        Collections.sort(list, (o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getTitle(), o2.getTitle()));
        return list;
    }

    private static Map<String, LicenseInfo> extractUniqueLicenses(List<ArtifactAndLicense> artifacts) {
        TreeMap<String, LicenseInfo> map = new TreeMap<String, LicenseInfo>();
        for (ArtifactAndLicense artifactAndLicense : artifacts) {
            List<LicenseInfo> licenses = artifactAndLicense.getLicenses();
            licenses.forEach(licenseInfo -> map.put(licenseInfo.getKey(), (LicenseInfo)licenseInfo));
        }
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File mergePages(File ... mergeFiles) {
        PDFMergerUtility merger = new PDFMergerUtility();
        File outFile = new File(this.workingDir, "merged.attribute-doc.pdf");
        try (FileOutputStream fos = new FileOutputStream(outFile);){
            merger.setDestinationStream((OutputStream)fos);
            merger.setDestinationFileName(outFile.getPath());
            for (File f : mergeFiles) {
                merger.addSource(f);
            }
            merger.mergeDocuments(MemoryUsageSetting.setupMainMemoryOnly());
            File file = outFile;
            return file;
        }
        catch (IOException e) {
            throw new ExecutionException("Merging single pages failed.", (Throwable)e);
        }
    }

    private void writeCopyRightFooter(PDFont font, float pageWidth, PDPageContentStream contents) throws IOException {
        TextFlow copyright = new TextFlow();
        copyright.setMaxWidth(pageWidth - 50.0f);
        copyright.addText("\u00a9 " + this.values.getCopyrightHolder(), 8.0f, font);
        copyright.drawText(contents, new Position(70.0f, 39.0f), Alignment.Left, null);
    }

    private void writePageNumber(PDFont font, float pageWidth, PDPageContentStream contents, String runningNumber) throws IOException {
        TextFlow pageNum = new TextFlow();
        pageNum.setMaxWidth(pageWidth - 50.0f);
        pageNum.addText(runningNumber, 8.0f, font);
        pageNum.drawText(contents, new Position(500.0f, 39.0f), Alignment.Left, null);
    }

    private File writeBackPage(PDDocument backPage) {
        return this.writePage(backPage, Paths.get(this.workingDir.getAbsolutePath(), "back.pdf"));
    }

    private File writeCopyright(Templates templates) {
        PDDocument copyright = templates.getCopyright();
        PDFont font = templates.loadSansFont(copyright);
        PDFWriterUtils.write(copyright, (text, pageHeight, pageWidth) -> {
            String string = "\u00a9 " + this.values.getCopyrightHolder() + ", " + this.values.getCopyrightYear() + ".";
            text.addText(string, 10.0f, font);
            return new Position(70.0f, pageHeight - 183.0f);
        });
        return this.writePage(copyright, Paths.get(this.workingDir.getAbsolutePath(), "copyright.pdf"));
    }

    private File writeTitle(Templates templates) {
        PDDocument titleTemplate = templates.getTitle();
        PDFont font = templates.loadSansFont(titleTemplate);
        PDFWriterUtils.write(titleTemplate, (text, pageHeight, pageWidth) -> {
            text.setMaxWidth(pageWidth - 150.0f);
            text.addText(this.values.getProductName(), 22.0f, font);
            text.addText("\n\nVersion " + this.values.getVersion(), 12.0f, font);
            return new Position(80.0f, pageHeight - 295.0f);
        });
        return this.writePage(titleTemplate, Paths.get(this.workingDir.getAbsolutePath(), "title.pdf"));
    }

    private File writePage(PDDocument document, Path path) {
        try {
            document.save(path.toFile());
            document.close();
            return path.toFile();
        }
        catch (IOException e) {
            throw new ExecutionException("Could not write page.", (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private File doOverlay(File file, PDDocument template, String newFileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void doSave(Document document, File file) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            document.save((OutputStream)fos);
        }
    }
}

