/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.attribution.document.core;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.eclipse.sw360.antenna.api.exceptions.ExecutionException;
import org.eclipse.sw360.antenna.attribution.document.core.AttributionDocumentGeneratorImpl;
import org.eclipse.sw360.antenna.attribution.document.core.TemplateBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Templates
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(AttributionDocumentGeneratorImpl.class);
    private PDDocument title;
    private PDDocument copyright;
    private PDDocument backPage;
    private PDDocument content;
    private byte[] fontDataSansBold;
    private byte[] fontDataSans;
    private byte[] fontDataBoldItalic;
    private byte[] fontDataSansItalic;

    public PDDocument getTitle() {
        return this.title;
    }

    public void setTitle(PDDocument title) {
        this.title = title;
    }

    public PDDocument getCopyright() {
        return this.copyright;
    }

    public void setCopyright(PDDocument copyright) {
        this.copyright = copyright;
    }

    public PDDocument getBackPage() {
        return this.backPage;
    }

    public void setBackPage(PDDocument backPage) {
        this.backPage = backPage;
    }

    public PDDocument getContent() {
        return this.content;
    }

    public void setContent(PDDocument content) {
        this.content = content;
    }

    public void loadFontDataForTemplate(TemplateBundle bundle) {
        this.fontDataSansBold = Templates.loadFontData(bundle.loadSansBoldFont());
        this.fontDataBoldItalic = Templates.loadFontData(bundle.loadSansBoldItalicFont());
        this.fontDataSans = Templates.loadFontData(bundle.loadSansFont());
        this.fontDataSansItalic = Templates.loadFontData(bundle.loadSansItalicFont());
    }

    public PDFont loadSansFont(PDDocument doc) {
        return this.fontDataSans.length > 0 ? Templates.loadFont(doc, this.fontDataSans) : PDType1Font.TIMES_ROMAN;
    }

    public PDFont loadSansBoldFont(PDDocument doc) {
        return this.fontDataSansBold.length > 0 ? Templates.loadFont(doc, this.fontDataSansBold) : PDType1Font.TIMES_BOLD;
    }

    public PDFont loadSansItalicFont(PDDocument doc) {
        return this.fontDataSansItalic.length > 0 ? Templates.loadFont(doc, this.fontDataSansItalic) : PDType1Font.TIMES_ITALIC;
    }

    public PDFont loadBoldItalicFont(PDDocument doc) {
        return this.fontDataBoldItalic.length > 0 ? Templates.loadFont(doc, this.fontDataBoldItalic) : PDType1Font.TIMES_BOLD_ITALIC;
    }

    private static byte[] loadFontData(Optional<InputStream> fontData) {
        if (fontData.isPresent()) {
            try {
                return IOUtils.toByteArray((InputStream)fontData.get());
            }
            catch (IOException e) {
                throw new ExecutionException("Unable to load font.", (Throwable)e);
            }
        }
        return new byte[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PDFont loadFont(PDDocument doc, byte[] data) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(data);){
            PDType0Font pDType0Font = PDType0Font.load((PDDocument)doc, (InputStream)is);
            return pDType0Font;
        }
        catch (IOException e) {
            throw new ExecutionException("Could not load font.", (Throwable)e);
        }
    }

    @Override
    public void close() {
        try {
            this.title.close();
        }
        catch (IOException e) {
            LOG.warn("Failed to close the title PDDocument page.");
            LOG.debug("Stacktrace: ", (Throwable)e);
        }
        try {
            this.content.close();
        }
        catch (IOException e) {
            LOG.warn("Failed to close the content PDDocument page.");
            LOG.debug("Stacktrace: ", (Throwable)e);
        }
        try {
            this.copyright.close();
        }
        catch (IOException e) {
            LOG.warn("Failed to close the copyright PDDocument page.");
            LOG.debug("Stacktrace: ", (Throwable)e);
        }
        try {
            this.backPage.close();
        }
        catch (IOException e) {
            LOG.warn("Failed to close the back PDDocument page.");
            LOG.debug("Stacktrace: ", (Throwable)e);
        }
    }
}

