/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.attribution.document.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.eclipse.sw360.antenna.api.exceptions.ExecutionException;
import org.eclipse.sw360.antenna.attribution.document.core.TemplateBundle;
import org.eclipse.sw360.antenna.attribution.document.core.Templates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TemplateLoaderUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TemplateLoaderUtil.class);

    private TemplateLoaderUtil() {
    }

    public static Templates load(String key) {
        return TemplateLoaderUtil.load(TemplateLoaderUtil.getLoader(key));
    }

    public static Templates load(final File cover, final File copyright, final File content, final File back) {
        return TemplateLoaderUtil.load(new TemplateBundle(){

            @Override
            public String key() {
                return "";
            }

            @Override
            public InputStream loadTitleTemplate() {
                try {
                    return new FileInputStream(cover);
                }
                catch (IOException e) {
                    throw new ExecutionException("Could not load cover template PDF", (Throwable)e);
                }
            }

            @Override
            public InputStream loadCopyrightTemplate() {
                try {
                    return new FileInputStream(copyright);
                }
                catch (IOException e) {
                    throw new ExecutionException("Could not load copyright template PDF", (Throwable)e);
                }
            }

            @Override
            public InputStream loadContentTemplate() {
                try {
                    return new FileInputStream(content);
                }
                catch (IOException e) {
                    throw new ExecutionException("Could not load copyright template PDF", (Throwable)e);
                }
            }

            @Override
            public InputStream loadBackPageTemplate() {
                try {
                    return new FileInputStream(back);
                }
                catch (IOException e) {
                    throw new ExecutionException("Could not load back template PDF", (Throwable)e);
                }
            }
        });
    }

    public static Templates load(TemplateBundle bundle) {
        Templates templates = new Templates();
        templates.setTitle(TemplateLoaderUtil.loadTemplate(bundle::loadTitleTemplate));
        templates.setCopyright(TemplateLoaderUtil.loadTemplate(bundle::loadCopyrightTemplate));
        templates.setBackPage(TemplateLoaderUtil.loadTemplate(bundle::loadBackPageTemplate));
        templates.setContent(TemplateLoaderUtil.loadTemplate(bundle::loadContentTemplate));
        templates.loadFontDataForTemplate(bundle);
        return templates;
    }

    private static TemplateBundle getLoader(String templateKey) {
        ServiceLoader<TemplateBundle> load = ServiceLoader.load(TemplateBundle.class);
        for (TemplateBundle templateBundle : load) {
            if (!templateKey.equalsIgnoreCase(templateBundle.key())) continue;
            LOG.debug("Loaded implementation {} for key {}", (Object)templateBundle.getClass().getName(), (Object)templateKey);
            return templateBundle;
        }
        throw new ExecutionException("Unable to locate a template bundle for key '" + templateKey + "'. Please check your classpath or configuration.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PDDocument loadTemplate(Supplier<InputStream> fileLoader) {
        try (InputStream is = fileLoader.get();){
            PDDocument pDDocument = PDDocument.load((InputStream)is);
            return pDDocument;
        }
        catch (Exception e) {
            throw new ExecutionException("Unable to load template", (Throwable)e);
        }
    }
}

