/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.attribution.document.workflow.generators;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.sw360.antenna.attribution.document.core.model.ArtifactAndLicense;
import org.eclipse.sw360.antenna.attribution.document.core.model.LicenseInfo;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.model.artifact.ArtifactCoordinates;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactFilename;
import org.eclipse.sw360.antenna.model.artifact.facts.CopyrightStatement;
import org.eclipse.sw360.antenna.model.artifact.facts.java.ArtifactPathnames;
import org.eclipse.sw360.antenna.model.license.License;
import org.eclipse.sw360.antenna.model.license.LicenseInformation;
import org.eclipse.sw360.antenna.model.util.ArtifactLicenseUtils;

public class ArtifactAdapter
implements ArtifactAndLicense {
    private final String filename;
    private final Optional<String> copyrightStatement;
    private final List<LicenseInfo> licenses;
    private final String purl;

    public ArtifactAdapter(Artifact artifact) {
        this.filename = ArtifactAdapter.figureOutArtifactFilename(artifact);
        this.copyrightStatement = artifact.askForGet(CopyrightStatement.class);
        this.licenses = ArtifactAdapter.createLicenses(ArtifactLicenseUtils.getFinalLicenses((Artifact)artifact));
        this.purl = ArtifactAdapter.toPurl(artifact);
    }

    public static String getLicenseText(License license) {
        String text = license.getText();
        if (StringUtils.isBlank((CharSequence)text)) {
            return "No license text available";
        }
        return text.replace("\t", "    ").replace("\u00a0", " ").replace("\u200b", "").replace("\u2028", "\n").replace("\ufeff", "");
    }

    public static String createKey(License license) {
        int hashCode = license.getId().hashCode();
        String prefix = hashCode < 0 ? "n" : "p";
        return prefix + Math.abs(hashCode);
    }

    public String getFilename() {
        return this.filename;
    }

    public List<LicenseInfo> getLicenses() {
        return this.licenses;
    }

    public Optional<String> getCopyrightStatement() {
        return this.copyrightStatement;
    }

    public Optional<String> getPurl() {
        return Optional.ofNullable(this.purl);
    }

    private static String figureOutArtifactFilename(Artifact artifact) {
        return artifact.askFor(ArtifactFilename.class).map(ArtifactAdapter::figureOutArtifactFilename).orElse(artifact.askFor(ArtifactPathnames.class).map(ArtifactAdapter::figureOutArtifactFilename).filter(s -> s.equals("null")).orElse(""));
    }

    private static String figureOutArtifactFilename(ArtifactFilename artifactFilename) {
        return artifactFilename.getFilenames().stream().collect(Collectors.joining(", "));
    }

    private static String figureOutArtifactFilename(ArtifactPathnames artifactPathnames) {
        return ((List)artifactPathnames.get()).stream().map(FilenameUtils::getName).distinct().collect(Collectors.joining(", "));
    }

    private static List<LicenseInfo> createLicenses(LicenseInformation licenseInformation) {
        return licenseInformation.getLicenses().stream().map(l -> new LicenseInfo(ArtifactAdapter.createKey(l), ArtifactAdapter.getLicenseText(l), l.getId(), l.getCommonName())).collect(Collectors.toList());
    }

    private static String toPurl(Artifact artifact) {
        return artifact.askFor(ArtifactCoordinates.class).map(ArtifactCoordinates::getMainCoordinate).map(l -> l.canonicalize()).orElse("");
    }
}

