/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.attribution.document.workflow.generators;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.sw360.antenna.api.Attachable;
import org.eclipse.sw360.antenna.api.IAttachable;
import org.eclipse.sw360.antenna.api.workflow.AbstractGenerator;
import org.eclipse.sw360.antenna.api.workflow.ProcessingState;
import org.eclipse.sw360.antenna.attribution.document.core.AttributionDocumentGeneratorImpl;
import org.eclipse.sw360.antenna.attribution.document.core.DocumentValues;
import org.eclipse.sw360.antenna.attribution.document.core.model.ArtifactAndLicense;
import org.eclipse.sw360.antenna.attribution.document.workflow.generators.ArtifactAdapter;
import org.eclipse.sw360.antenna.attribution.document.workflow.generators.ArtifactAndLicenseComparator;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributionDocumentGenerator
extends AbstractGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(AttributionDocumentGenerator.class);
    private static final String DEFAULT_ATTRIBUTION_DOC_NAME = "attribution-document.pdf";
    private static final String DEFAULT_TEMPLATE_KEY = "basic-pdf-template";
    private static final String IDENTIFIER = "antenna-attribution-doc";
    private static final String CLASSIFIER = "antenna-attribution-doc";
    private static final String TYPE = "pdf";
    private static final String CONFIG_DOC_NAME = "attribution.doc.name";
    private static final String CONFIG_TEMPLATE_KEY = "attribution.doc.templateKey";
    private static final String CONFIG_PRODUCT_NAME = "attribution.doc.productName";
    private static final String CONFIG_PRODUCT_VERSION = "attribution.doc.productVersion";
    private static final String CONFIG_COPYRIGHT_HOLDER = "attribution.doc.copyrightHolder";
    private static final String WORKING_DIR_NAME = "doc-gen";
    private DocumentValues values;
    private String templateKey;
    private String docName;
    private File docGenDir;

    public AttributionDocumentGenerator() {
        this.workflowStepOrder = (short)700;
    }

    public Map<String, IAttachable> produce(ProcessingState previousState) {
        return this.produce(previousState.getArtifacts());
    }

    public Map<String, IAttachable> produce(Collection<Artifact> artifacts) {
        long start = System.currentTimeMillis();
        LOG.info("Generating pdf report.");
        Path antennaDir = this.context.getToolConfiguration().getAntennaTargetDirectory();
        this.docGenDir = this.createWorkDir(antennaDir);
        AttributionDocumentGeneratorImpl disDoc = new AttributionDocumentGeneratorImpl(this.docName, this.docGenDir, this.templateKey, this.values);
        File attributionDoc = disDoc.generate(this.convertAndSort(artifacts));
        long duration = System.currentTimeMillis() - start;
        LOG.debug("Generating pdf report finished in {}ms.", (Object)duration);
        return Collections.singletonMap("antenna-attribution-doc", new Attachable(TYPE, "antenna-attribution-doc", attributionDoc));
    }

    private List<ArtifactAndLicense> convertAndSort(Collection<Artifact> artifacts) {
        List<ArtifactAndLicense> list = artifacts.stream().filter(artifact -> !artifact.isProprietary()).map(ArtifactAdapter::new).collect(Collectors.toList());
        Collections.sort(list, new ArtifactAndLicenseComparator());
        return list;
    }

    public void configure(Map<String, String> configMap) {
        String confProductName = this.getConfigValue(CONFIG_PRODUCT_NAME, configMap, this.context.getToolConfiguration().getProductFullName());
        String confProductVersion = this.getConfigValue(CONFIG_PRODUCT_VERSION, configMap, this.context.getToolConfiguration().getVersion());
        String confCopyrightHolder = this.getConfigValue(CONFIG_COPYRIGHT_HOLDER, configMap);
        this.docName = this.getConfigValue(CONFIG_DOC_NAME, configMap, DEFAULT_ATTRIBUTION_DOC_NAME);
        this.templateKey = this.getConfigValue(CONFIG_TEMPLATE_KEY, configMap, DEFAULT_TEMPLATE_KEY);
        this.values = new DocumentValues(confProductName, confProductVersion, confCopyrightHolder);
    }

    private File createWorkDir(Path antennaDir) {
        File workDir = new File(antennaDir.toFile(), WORKING_DIR_NAME);
        if (!workDir.mkdirs()) {
            LOG.debug("The working directory {} already exists. The existing files will be overwritten.", (Object)workDir);
        }
        return workDir;
    }

    public void cleanup() {
        if (this.docGenDir != null) {
            Path cleanUpDir = this.docGenDir.toPath();
            if (!this.context.getDebug()) {
                try {
                    Files.walk(cleanUpDir, new FileVisitOption[0]).filter(p -> !p.getFileName().equals(Paths.get(this.docName, new String[0]))).map(Path::toFile).forEach(File::delete);
                }
                catch (IOException e) {
                    LOG.debug("Failed to clean up temporary directory=[" + this.docGenDir + "] for the generation of the attribution document");
                }
            }
        }
    }
}

