/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.policies;

import java.util.Optional;
import org.eclipse.sw360.antenna.policy.engine.PolicyViolation;
import org.eclipse.sw360.antenna.policy.engine.Rule;
import org.eclipse.sw360.antenna.policy.engine.RuleSeverity;
import org.eclipse.sw360.antenna.policy.engine.RuleUtils;
import org.eclipse.sw360.antenna.policy.engine.Ruleset;
import org.eclipse.sw360.antenna.policy.engine.SingleArtifactRule;
import org.eclipse.sw360.antenna.policy.engine.model.ThirdPartyArtifact;

public class ArtifactKnownRule
implements SingleArtifactRule {
    private final Ruleset ruleset;

    public ArtifactKnownRule(Ruleset ruleset) {
        this.ruleset = ruleset;
    }

    public Optional<PolicyViolation> evaluate(ThirdPartyArtifact thirdPartyArtifact) {
        if (thirdPartyArtifact.isProprietary() || this.coordinatesAvailable(thirdPartyArtifact)) {
            return RuleUtils.artifactAppliesToRule((Rule)this, (ThirdPartyArtifact[])new ThirdPartyArtifact[]{thirdPartyArtifact});
        }
        return RuleUtils.artifactRaisesPolicyViolation((Rule)this, (ThirdPartyArtifact[])new ThirdPartyArtifact[]{thirdPartyArtifact});
    }

    private boolean coordinatesAvailable(ThirdPartyArtifact thirdPartyArtifact) {
        return thirdPartyArtifact.getCoordinates().stream().anyMatch(purl -> !"generic".equals(purl.getType()));
    }

    public String getId() {
        return "ArtifactIdentified";
    }

    public String getName() {
        return "Artifact Known Rule";
    }

    public String getDescription() {
        return "Artifact could not be identified, no technology specific coordinates available!";
    }

    public RuleSeverity getSeverity() {
        return RuleSeverity.CRITICAL;
    }

    public Ruleset getRuleset() {
        return this.ruleset;
    }
}

