/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.policies;

import java.util.Optional;
import org.eclipse.sw360.antenna.policy.engine.PolicyViolation;
import org.eclipse.sw360.antenna.policy.engine.Rule;
import org.eclipse.sw360.antenna.policy.engine.RuleSeverity;
import org.eclipse.sw360.antenna.policy.engine.RuleUtils;
import org.eclipse.sw360.antenna.policy.engine.Ruleset;
import org.eclipse.sw360.antenna.policy.engine.SingleArtifactRule;
import org.eclipse.sw360.antenna.policy.engine.model.ThirdPartyArtifact;

public class LicenseSelectedRule
implements SingleArtifactRule {
    private final Ruleset ruleset;

    public LicenseSelectedRule(Ruleset ruleset) {
        this.ruleset = ruleset;
    }

    public Optional<PolicyViolation> evaluate(ThirdPartyArtifact thirdPartyArtifact) {
        if (thirdPartyArtifact.isProprietary() || this.licenseExpressionOk(thirdPartyArtifact)) {
            return RuleUtils.artifactAppliesToRule((Rule)this, (ThirdPartyArtifact[])new ThirdPartyArtifact[]{thirdPartyArtifact});
        }
        return RuleUtils.artifactRaisesPolicyViolation((Rule)this, (ThirdPartyArtifact[])new ThirdPartyArtifact[]{thirdPartyArtifact});
    }

    private boolean licenseExpressionOk(ThirdPartyArtifact thirdPartyArtifact) {
        return !thirdPartyArtifact.getLicenseExpression().map(String::toLowerCase).filter(expression -> expression.contains(" or ")).isPresent();
    }

    public String getId() {
        return "LicenseSelected";
    }

    public String getName() {
        return "License Selected Rule";
    }

    public String getDescription() {
        return "The artifact has a selectable license expression and the selection is open!";
    }

    public RuleSeverity getSeverity() {
        return RuleSeverity.CRITICAL;
    }

    public Ruleset getRuleset() {
        return this.ruleset;
    }
}

