/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.policies;

import java.util.Optional;
import org.eclipse.sw360.antenna.policy.engine.PolicyViolation;
import org.eclipse.sw360.antenna.policy.engine.Rule;
import org.eclipse.sw360.antenna.policy.engine.RuleSeverity;
import org.eclipse.sw360.antenna.policy.engine.RuleUtils;
import org.eclipse.sw360.antenna.policy.engine.Ruleset;
import org.eclipse.sw360.antenna.policy.engine.SingleArtifactRule;
import org.eclipse.sw360.antenna.policy.engine.model.LicenseState;
import org.eclipse.sw360.antenna.policy.engine.model.ThirdPartyArtifact;

public class QualifiedComplexLicenseRule
implements SingleArtifactRule {
    private final Ruleset ruleset;

    public QualifiedComplexLicenseRule(Ruleset ruleset) {
        this.ruleset = ruleset;
    }

    public Optional<PolicyViolation> evaluate(ThirdPartyArtifact thirdPartyArtifact) {
        if (thirdPartyArtifact.isProprietary() || this.licenseStateOk(thirdPartyArtifact)) {
            return RuleUtils.artifactAppliesToRule((Rule)this, (ThirdPartyArtifact[])new ThirdPartyArtifact[]{thirdPartyArtifact});
        }
        return RuleUtils.artifactRaisesPolicyViolation((Rule)this, (ThirdPartyArtifact[])new ThirdPartyArtifact[]{thirdPartyArtifact});
    }

    private boolean licenseStateOk(ThirdPartyArtifact thirdPartyArtifact) {
        return thirdPartyArtifact.getLicenseState() == LicenseState.EXPLICITLY_SET || thirdPartyArtifact.getLicenses().size() <= 2;
    }

    public String getId() {
        return "QualifiedComplexLicense";
    }

    public String getName() {
        return "Qualified Complex License Rule";
    }

    public String getDescription() {
        return "Artifact has a complex license situation, i.e., more than 2 licenses involved. It should be approved by a compliance expert!";
    }

    public RuleSeverity getSeverity() {
        return RuleSeverity.SEVERE;
    }

    public Ruleset getRuleset() {
        return this.ruleset;
    }
}

