/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.policies;

import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.eclipse.sw360.antenna.policy.engine.PolicyViolation;
import org.eclipse.sw360.antenna.policy.engine.Rule;
import org.eclipse.sw360.antenna.policy.engine.RuleSeverity;
import org.eclipse.sw360.antenna.policy.engine.RuleUtils;
import org.eclipse.sw360.antenna.policy.engine.Ruleset;
import org.eclipse.sw360.antenna.policy.engine.SingleArtifactRule;
import org.eclipse.sw360.antenna.policy.engine.model.ThirdPartyArtifact;

public class SourcesAvailableRule
implements SingleArtifactRule {
    private final Ruleset ruleset;

    public SourcesAvailableRule(Ruleset ruleset) {
        this.ruleset = ruleset;
    }

    public Optional<PolicyViolation> evaluate(ThirdPartyArtifact thirdPartyArtifact) {
        if (thirdPartyArtifact.isProprietary()) {
            return RuleUtils.artifactAppliesToRule((Rule)this, (ThirdPartyArtifact[])new ThirdPartyArtifact[]{thirdPartyArtifact});
        }
        if (thirdPartyArtifact.getSourceFileOrLink().filter(url -> url.getProtocol().equals("file")).map(this::urlToPath).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).isPresent()) {
            return RuleUtils.artifactAppliesToRule((Rule)this, (ThirdPartyArtifact[])new ThirdPartyArtifact[]{thirdPartyArtifact});
        }
        return RuleUtils.artifactRaisesPolicyViolation((Rule)this, (ThirdPartyArtifact[])new ThirdPartyArtifact[]{thirdPartyArtifact});
    }

    private Path urlToPath(URL url) {
        try {
            return Paths.get(url.toURI());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public String getId() {
        return "SourcesAvailable";
    }

    public String getName() {
        return "Sources Available Rule";
    }

    public String getDescription() {
        return "The artifact sources are not available locally!";
    }

    public RuleSeverity getSeverity() {
        return RuleSeverity.SEVERE;
    }

    public Ruleset getRuleset() {
        return this.ruleset;
    }
}

