/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.policies;

import java.util.Optional;
import org.eclipse.sw360.antenna.policy.engine.PolicyViolation;
import org.eclipse.sw360.antenna.policy.engine.Rule;
import org.eclipse.sw360.antenna.policy.engine.RuleSeverity;
import org.eclipse.sw360.antenna.policy.engine.RuleUtils;
import org.eclipse.sw360.antenna.policy.engine.Ruleset;
import org.eclipse.sw360.antenna.policy.engine.SingleArtifactRule;
import org.eclipse.sw360.antenna.policy.engine.model.LicenseState;
import org.eclipse.sw360.antenna.policy.engine.model.ThirdPartyArtifact;

public class ArtifactLicenseQualifiedRule
implements SingleArtifactRule {
    private final Ruleset ruleset;

    public ArtifactLicenseQualifiedRule(Ruleset ruleset) {
        this.ruleset = ruleset;
    }

    public Optional<PolicyViolation> evaluate(ThirdPartyArtifact thirdPartyArtifact) {
        if (thirdPartyArtifact.isProprietary() || this.licenseStateOk(thirdPartyArtifact)) {
            return RuleUtils.artifactAppliesToRule((Rule)this, (ThirdPartyArtifact[])new ThirdPartyArtifact[]{thirdPartyArtifact});
        }
        return RuleUtils.artifactRaisesPolicyViolation((Rule)this, (ThirdPartyArtifact[])new ThirdPartyArtifact[]{thirdPartyArtifact});
    }

    private boolean licenseStateOk(ThirdPartyArtifact thirdPartyArtifact) {
        return thirdPartyArtifact.getLicenseState() == LicenseState.DECLARED_AND_OBSERVED || thirdPartyArtifact.getLicenseState() == LicenseState.EXPLICITLY_SET;
    }

    public String getId() {
        return "ArtifactLicenseQualified";
    }

    public String getName() {
        return "Artifact License Qualified Rule";
    }

    public String getDescription() {
        return "The artifact needs either a declared and an observed license or an explicit license statement. This is not the case, so the valid component license is unclear!";
    }

    public RuleSeverity getSeverity() {
        return RuleSeverity.SEVERE;
    }

    public Ruleset getRuleset() {
        return this.ruleset;
    }
}

