/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.policies;

import java.util.Optional;
import org.eclipse.sw360.antenna.policy.engine.PolicyViolation;
import org.eclipse.sw360.antenna.policy.engine.Rule;
import org.eclipse.sw360.antenna.policy.engine.RuleSeverity;
import org.eclipse.sw360.antenna.policy.engine.RuleUtils;
import org.eclipse.sw360.antenna.policy.engine.Ruleset;
import org.eclipse.sw360.antenna.policy.engine.SingleArtifactRule;
import org.eclipse.sw360.antenna.policy.engine.model.LicenseData;
import org.eclipse.sw360.antenna.policy.engine.model.ThirdPartyArtifact;

public class LicenseQualifiedRule
implements SingleArtifactRule {
    private final Ruleset ruleset;

    public LicenseQualifiedRule(Ruleset ruleset) {
        this.ruleset = ruleset;
    }

    public Optional<PolicyViolation> evaluate(ThirdPartyArtifact thirdPartyArtifact) {
        if (thirdPartyArtifact.isProprietary() || this.allLicensesAreOk(thirdPartyArtifact)) {
            return RuleUtils.artifactAppliesToRule((Rule)this, (ThirdPartyArtifact[])new ThirdPartyArtifact[]{thirdPartyArtifact});
        }
        return RuleUtils.artifactRaisesPolicyViolation((Rule)this, (ThirdPartyArtifact[])new ThirdPartyArtifact[]{thirdPartyArtifact});
    }

    private boolean allLicensesAreOk(ThirdPartyArtifact thirdPartyArtifact) {
        return thirdPartyArtifact.getLicenses().stream().map(LicenseData::getLicenseText).filter(optionalText -> !optionalText.isPresent()).count() == 0L;
    }

    public String getId() {
        return "LicenseQualified";
    }

    public String getName() {
        return "License Qualified Rule";
    }

    public String getDescription() {
        return "A license referenced by the artifact has no associated license text, it cannot be redistributed!";
    }

    public RuleSeverity getSeverity() {
        return RuleSeverity.CRITICAL;
    }

    public Ruleset getRuleset() {
        return this.ruleset;
    }
}

