/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.policies;

import java.util.Optional;
import org.eclipse.sw360.antenna.policy.engine.PolicyViolation;
import org.eclipse.sw360.antenna.policy.engine.Rule;
import org.eclipse.sw360.antenna.policy.engine.RuleSeverity;
import org.eclipse.sw360.antenna.policy.engine.RuleUtils;
import org.eclipse.sw360.antenna.policy.engine.Ruleset;
import org.eclipse.sw360.antenna.policy.engine.SingleArtifactRule;
import org.eclipse.sw360.antenna.policy.engine.model.LicenseState;
import org.eclipse.sw360.antenna.policy.engine.model.ThirdPartyArtifact;

public class ArtifactLicenseKnownRule
implements SingleArtifactRule {
    private final Ruleset ruleset;

    public ArtifactLicenseKnownRule(Ruleset ruleset) {
        this.ruleset = ruleset;
    }

    public Optional<PolicyViolation> evaluate(ThirdPartyArtifact thirdPartyArtifact) {
        if (thirdPartyArtifact.isProprietary() || thirdPartyArtifact.getLicenseState() != LicenseState.NO_LICENSE) {
            return RuleUtils.artifactAppliesToRule((Rule)this, (ThirdPartyArtifact[])new ThirdPartyArtifact[]{thirdPartyArtifact});
        }
        return RuleUtils.artifactRaisesPolicyViolation((Rule)this, (ThirdPartyArtifact[])new ThirdPartyArtifact[]{thirdPartyArtifact});
    }

    public String getId() {
        return "ArtifactLicenseKnown";
    }

    public String getName() {
        return "Artifact License Known Rule";
    }

    public String getDescription() {
        return "Artifact has no known license information, cannot be redistributed!";
    }

    public RuleSeverity getSeverity() {
        return RuleSeverity.CRITICAL;
    }

    public Ruleset getRuleset() {
        return this.ruleset;
    }
}

