/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.frontend.stub.cli;

import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.sw360.antenna.api.IAttachable;
import org.eclipse.sw360.antenna.api.IProcessingReporter;
import org.eclipse.sw360.antenna.api.IProject;
import org.eclipse.sw360.antenna.api.configuration.ToolConfiguration;
import org.eclipse.sw360.antenna.api.exceptions.ConfigurationException;
import org.eclipse.sw360.antenna.api.exceptions.ExecutionException;
import org.eclipse.sw360.antenna.core.AntennaCore;
import org.eclipse.sw360.antenna.frontend.AntennaFrontend;
import org.eclipse.sw360.antenna.frontend.AntennaFrontendHelper;
import org.eclipse.sw360.antenna.frontend.MetaDataStoringProject;
import org.eclipse.sw360.antenna.frontend.stub.cli.AntennaCLISettingsReader;
import org.eclipse.sw360.antenna.frontend.stub.cli.CliProject;
import org.eclipse.sw360.antenna.model.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAntennaCLIFrontend
implements AntennaFrontend<MetaDataStoringProject> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAntennaCLIFrontend.class);
    private final Map<String, IAttachable> output = new HashMap<String, IAttachable>();
    private final MetaDataStoringProject project;
    private final String pluginDescendantArtifactIdName = this.getPluginDescendantArtifactIdName();

    public AbstractAntennaCLIFrontend(File pomFilePath, File propertiesFile) {
        this(pomFilePath);
        this.project.setPropertiesFile(propertiesFile);
    }

    public AbstractAntennaCLIFrontend(File pomFile) {
        Path buildDir = this.getBuildDirFromPomFile(pomFile);
        Path sourceDir = this.getSourceDirFromPomFile(pomFile);
        this.project = new CliProject(pomFile, buildDir.toString(), sourceDir.toString());
    }

    protected abstract String getPluginDescendantArtifactIdName();

    private Path getSourceDirFromPomFile(File pomFile) {
        Path parent = (Path)Utils.getParent((Path)pomFile.toPath()).orElseThrow(() -> new IllegalArgumentException("Could not get source dir from pomFile=[" + pomFile + "]"));
        return parent.resolve("src");
    }

    private Path getBuildDirFromPomFile(File pomFile) {
        Path parent = (Path)Utils.getParent((Path)pomFile.toPath()).orElseThrow(() -> new IllegalArgumentException("Could not get build dir from pomFile=[" + pomFile + "]"));
        return this.getBuildDirFromFolder(parent);
    }

    protected Path getBuildDirFromFolder(Path folder) {
        return folder.resolve("target");
    }

    public AntennaFrontendHelper init() {
        ToolConfiguration toolConfiguration = new AntennaCLISettingsReader(this.pluginDescendantArtifactIdName).readSettingsToToolConfiguration(this.getProject());
        return new AntennaFrontendHelper((IProject)this.getProject()).setToolConfiguration(toolConfiguration);
    }

    public void execute() {
        AntennaCore antennaCore;
        try {
            AntennaFrontendHelper antennaFrontendHelper = this.init();
            antennaCore = antennaFrontendHelper.buildAntennaCore();
        }
        catch (ConfigurationException e) {
            LOGGER.error("AntennaCore was not initialized sucessfully");
            throw e;
        }
        try {
            this.output.putAll(antennaCore.compose());
        }
        catch (ExecutionException e) {
            LOGGER.error("Antenna execution failed due to: " + e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            IAttachable report = antennaCore.writeAnalysisReport();
            this.output.put(IProcessingReporter.getIdentifier(), report);
        }
    }

    public Map<String, IAttachable> getOutputs() {
        return this.output;
    }

    public MetaDataStoringProject getProject() {
        return this.project;
    }
}

