/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.frontend.stub.cli;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractAntennaCLIOptions {
    public static final String SWITCH_PREFIX = "-";
    public static final String PARAMETER_IDENTIFIER = "=";
    public static final String SWITCH_DEBUG_SHORT = "-X";
    public static final String SWITCH_DEBUG_LONG = "--debug";
    public static final String SWITCH_HELP_SHORT = "-h";
    public static final String SWITCH_HELP_LONG = "--help";
    protected final boolean debugLog;
    protected final boolean showHelp;
    protected final boolean valid;

    protected AbstractAntennaCLIOptions(boolean debugLog, boolean showHelp, boolean valid) {
        this.debugLog = debugLog;
        this.showHelp = showHelp;
        this.valid = valid;
    }

    public boolean isDebugLog() {
        return this.debugLog;
    }

    public boolean isShowHelp() {
        return this.showHelp;
    }

    public boolean isValid() {
        return this.valid;
    }

    public abstract String toString();

    protected static List<String> readPathsFromArgs(String[] args) {
        return Arrays.stream(args).filter(arg -> !AbstractAntennaCLIOptions.isSwitch(arg)).filter(arg -> !AbstractAntennaCLIOptions.isParameter(arg)).collect(Collectors.toList());
    }

    protected static Set<String> readParametersFromArgs(String[] args) {
        return Arrays.stream(args).filter(AbstractAntennaCLIOptions::isParameter).collect(Collectors.toSet());
    }

    protected static Set<String> readSwitchesFromArgs(String[] args) {
        return Arrays.stream(args).filter(AbstractAntennaCLIOptions::isSwitch).collect(Collectors.toSet());
    }

    protected static boolean isSwitch(String arg) {
        return arg.startsWith(SWITCH_PREFIX) && !arg.contains(PARAMETER_IDENTIFIER);
    }

    protected static boolean isParameter(String arg) {
        return arg.startsWith(SWITCH_PREFIX) && arg.contains(PARAMETER_IDENTIFIER);
    }

    protected static boolean hasSwitch(Set<String> switches, String name) {
        return switches.remove(name);
    }

    protected static boolean hasUnsupportedSwitches(Set<String> switches) {
        return !switches.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractAntennaCLIOptions that = (AbstractAntennaCLIOptions)o;
        return this.isDebugLog() == that.isDebugLog() && this.isShowHelp() == that.isShowHelp() && this.isValid() == that.isValid();
    }

    public int hashCode() {
        return Objects.hash(this.isDebugLog(), this.isShowHelp(), this.isValid());
    }
}

