/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.frontend.stub.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.sw360.antenna.api.configuration.ToolConfiguration;
import org.eclipse.sw360.antenna.api.exceptions.ConfigurationException;
import org.eclipse.sw360.antenna.frontend.MetaDataStoringProject;
import org.eclipse.sw360.antenna.model.xml.generated.Workflow;
import org.eclipse.sw360.antenna.util.TemplateRenderer;
import org.eclipse.sw360.antenna.util.XmlSettingsReader;
import org.eclipse.sw360.antenna.workflow.WorkflowFileLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class AntennaCLISettingsReader {
    private static final Logger log = LoggerFactory.getLogger(AntennaCLISettingsReader.class);
    private String antennaConfXpath;
    private TemplateRenderer tr = new TemplateRenderer();

    public AntennaCLISettingsReader() {
        this("antenna-maven-plugin");
    }

    public AntennaCLISettingsReader(String pluginDescendantArtifactName) {
        this.antennaConfXpath = "descendant::plugin[artifactId='" + pluginDescendantArtifactName + "']/descendant-or-self::configuration";
    }

    private void readProjectStringSetting(XmlSettingsReader reader, String name, Consumer<String> setter) {
        String value = reader.getStringProperty(name);
        if (value != null) {
            setter.accept(value);
        }
    }

    private void readAntennaStringSetting(XmlSettingsReader reader, String name, Consumer<String> setter) {
        String value = reader.getStringPropertyByXPath(this.antennaConfXpath, name);
        if (value != null) {
            setter.accept(value);
        }
    }

    private void readAntennaStringSetting(XmlSettingsReader reader, String name, String defaultValue, Consumer<String> setter) {
        String value = reader.getStringPropertyByXPath(this.antennaConfXpath, name, defaultValue);
        if (value != null) {
            setter.accept(value);
        }
    }

    private void readAntennaIntSetting(XmlSettingsReader reader, String name, int defaultValue, Consumer<Integer> setter) {
        int value = reader.getIntProperty(this.antennaConfXpath, name, defaultValue);
        setter.accept(value);
    }

    private void readAntennaBooleanSetting(XmlSettingsReader reader, String name, boolean defaultValue, Consumer<Boolean> setter) {
        boolean value = reader.getBooleanProperty(this.antennaConfXpath, name, defaultValue);
        setter.accept(value);
    }

    private void readStringListSetting(XmlSettingsReader reader, String name, Consumer<List<String>> setter) {
        List value = reader.getStringListProperty(name);
        if (value != null) {
            setter.accept(value);
        }
    }

    private List<File> buildFileList(List<String> paths) {
        return paths.stream().map(File::new).collect(Collectors.toList());
    }

    private void readFileListSetting(XmlSettingsReader reader, String name, Consumer<List<File>> setter) {
        this.readStringListSetting(reader, name, v -> setter.accept(this.buildFileList((List<String>)v)));
    }

    public ToolConfiguration readSettingsToToolConfiguration(MetaDataStoringProject project) {
        this.setVersionFromPom(project);
        XmlSettingsReader reader = this.getSettingsReader(project);
        return this.readSettingsToToolConfiguration(reader, project);
    }

    private void setVersionFromPom(MetaDataStoringProject project) {
        File pomFile = project.getConfigFile();
        try {
            String pom = new String(Files.readAllBytes(pomFile.toPath()), StandardCharsets.UTF_8);
            XmlSettingsReader reader = new XmlSettingsReader(pom);
            String version = reader.getStringPropertyByXPath("project", "version");
            if (version != null && !"".equals(version)) {
                project.setVersion(version);
                return;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            log.warn("Failed to parse the pom to extract the version", (Throwable)e);
        }
        if (project.getVersion() == null || project.getVersion().isEmpty()) {
            project.setVersion("1.0");
        }
    }

    private XmlSettingsReader getSettingsReader(MetaDataStoringProject project) {
        File pomFile = project.getConfigFile();
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        contextMap.put("project", project);
        contextMap.put("basedir", project.getBasedir());
        Optional.ofNullable(project.getPropertiesFile()).map(this::mapProperties).ifPresent(contextMap::putAll);
        System.getProperties().entrySet().stream().filter(e -> e.getKey().toString().startsWith("proxy")).forEach(e -> contextMap.put(e.getKey().toString(), e.getValue().toString()));
        String renderedPom = this.tr.renderTemplateFile(pomFile, contextMap);
        try {
            return new XmlSettingsReader(renderedPom);
        }
        catch (IOException | ParserConfigurationException | SAXException e2) {
            throw new ConfigurationException("Problem parsing the config: " + e2.getMessage());
        }
    }

    private String getDefaultAntennaTargetDirectory(MetaDataStoringProject project) {
        Path buildDir = Paths.get(project.getBuildDirectory(), new String[0]);
        return buildDir.resolve("antenna").toString();
    }

    ToolConfiguration.ConfigurationBuilder readBasicSettingsToToolConfigurationBuilder(XmlSettingsReader reader, MetaDataStoringProject project) throws IllegalArgumentException {
        ToolConfiguration.ConfigurationBuilder toolConfigBuilder = new ToolConfiguration.ConfigurationBuilder();
        this.readProjectStringSetting(reader, "artifactId", arg_0 -> ((MetaDataStoringProject)project).setProjectId(arg_0));
        this.readAntennaStringSetting(reader, "antennaTargetDirectory", this.getDefaultAntennaTargetDirectory(project), arg_0 -> ((ToolConfiguration.ConfigurationBuilder)toolConfigBuilder).setAntennaTargetDirectory(arg_0));
        this.readAntennaStringSetting(reader, "scanDir", arg_0 -> ((ToolConfiguration.ConfigurationBuilder)toolConfigBuilder).setScanDir(arg_0));
        this.readAntennaStringSetting(reader, "productName", reader.getStringProperty("productName"), arg_0 -> ((ToolConfiguration.ConfigurationBuilder)toolConfigBuilder).setProductName(arg_0));
        this.readAntennaStringSetting(reader, "productFullname", reader.getStringProperty("productFullname"), arg_0 -> ((ToolConfiguration.ConfigurationBuilder)toolConfigBuilder).setProductFullName(arg_0));
        this.readAntennaStringSetting(reader, "version", "1.0", arg_0 -> ((ToolConfiguration.ConfigurationBuilder)toolConfigBuilder).setVersion(arg_0));
        this.readAntennaStringSetting(reader, "companyName", arg_0 -> ((ToolConfiguration.ConfigurationBuilder)toolConfigBuilder).setCompanyName(arg_0));
        this.readAntennaStringSetting(reader, "copyrightHoldersName", arg_0 -> ((ToolConfiguration.ConfigurationBuilder)toolConfigBuilder).setCopyrightHoldersName(arg_0));
        this.readAntennaStringSetting(reader, "copyrightNotice", arg_0 -> ((ToolConfiguration.ConfigurationBuilder)toolConfigBuilder).setCopyrightNotice(arg_0));
        this.readAntennaStringSetting(reader, "attributionDocumentNotes", arg_0 -> ((ToolConfiguration.ConfigurationBuilder)toolConfigBuilder).setAttributionDocumentNotes(arg_0));
        this.readAntennaStringSetting(reader, "encodingCharSet", arg_0 -> ((ToolConfiguration.ConfigurationBuilder)toolConfigBuilder).setEncoding(arg_0));
        this.readAntennaStringSetting(reader, "proxyHost", arg_0 -> ((ToolConfiguration.ConfigurationBuilder)toolConfigBuilder).setProxyHost(arg_0));
        this.readAntennaIntSetting(reader, "proxyPort", 0, arg_0 -> ((ToolConfiguration.ConfigurationBuilder)toolConfigBuilder).setProxyPort(arg_0));
        this.readAntennaBooleanSetting(reader, "attachAll", false, arg_0 -> ((ToolConfiguration.ConfigurationBuilder)toolConfigBuilder).setAttachAll(arg_0));
        this.readAntennaBooleanSetting(reader, "skip", false, arg_0 -> ((ToolConfiguration.ConfigurationBuilder)toolConfigBuilder).setSkipAntennaExecution(arg_0));
        this.readAntennaBooleanSetting(reader, "showCopyrightStatements", false, arg_0 -> ((ToolConfiguration.ConfigurationBuilder)toolConfigBuilder).setShowCopyrightStatements(arg_0));
        this.readAntennaBooleanSetting(reader, "isMavenInstalled", false, arg_0 -> ((ToolConfiguration.ConfigurationBuilder)toolConfigBuilder).setMavenInstalled(arg_0));
        this.readStringListSetting(reader, "filesToAttach", arg_0 -> ((ToolConfiguration.ConfigurationBuilder)toolConfigBuilder).setFilesToAttach(arg_0));
        this.readFileListSetting(reader, "configFiles", arg_0 -> ((ToolConfiguration.ConfigurationBuilder)toolConfigBuilder).setConfigFiles(arg_0));
        return toolConfigBuilder;
    }

    public ToolConfiguration readSettingsToToolConfiguration(XmlSettingsReader reader, MetaDataStoringProject project) {
        ToolConfiguration.ConfigurationBuilder toolConfigBuilder = this.readBasicSettingsToToolConfigurationBuilder(reader, project);
        Optional<File> workflowDefFile = Optional.ofNullable(reader.getFileProperty("workflowDefinitionFile"));
        Workflow finalWorkflow = WorkflowFileLoader.loadWorkflowFromClassPath(workflowDefFile, (TemplateRenderer)this.tr);
        Workflow workflowFromConfig = (Workflow)reader.getComplexType("workflow", Workflow.class);
        if (workflowFromConfig != null) {
            WorkflowFileLoader.overrideWorkflow((Workflow)finalWorkflow, (Workflow)workflowFromConfig);
        }
        toolConfigBuilder.setWorkflow(finalWorkflow);
        return toolConfigBuilder.buildConfiguration();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> mapProperties(File propertiesFile) {
        try (FileInputStream input = new FileInputStream(propertiesFile);){
            Properties prop = new Properties();
            prop.load(input);
            Map<String, Object> map = prop.entrySet().stream().collect(Collectors.toMap(p -> p.getKey().toString(), p -> p.getValue().toString()));
            return map;
        }
        catch (IOException e) {
            throw new ConfigurationException("IO exception when reading properties file: " + e.getMessage());
        }
    }
}

