/*
 * Decompiled with CFR 0.152.
 */
package com.eclipse.sw360.antenna.cyclonedx;

import com.eclipse.sw360.antenna.cyclonedx.ArtifactToComponentConverter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.cyclonedx.BomGenerator;
import org.cyclonedx.BomGeneratorFactory;
import org.cyclonedx.CycloneDxSchema;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;
import org.eclipse.sw360.antenna.api.Attachable;
import org.eclipse.sw360.antenna.api.IAttachable;
import org.eclipse.sw360.antenna.api.configuration.ToolConfiguration;
import org.eclipse.sw360.antenna.api.exceptions.ExecutionException;
import org.eclipse.sw360.antenna.api.workflow.AbstractGenerator;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class CycloneDXGenerator
extends AbstractGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(CycloneDXGenerator.class);

    public Map<String, IAttachable> produce(Collection<Artifact> artifacts) throws ExecutionException {
        LOG.debug("Created a cyclone-dx bill-of-material for {} artifacts", (Object)artifacts.size());
        List<Component> components = this.toComponents(artifacts);
        Bom bom = new Bom();
        bom.setComponents(components);
        BomGenerator gen = BomGeneratorFactory.create((CycloneDxSchema.Version)CycloneDxSchema.Version.VERSION_11, (Bom)bom);
        File targetFile = this.createTargetFile();
        this.doGenerate(gen, targetFile);
        LOG.debug("Bill-of-material created in {}", (Object)targetFile);
        return Collections.singletonMap("cyclonedx-bom", new Attachable("xml", "cyclonedx-bom", targetFile));
    }

    protected File createTargetFile() {
        ToolConfiguration toolConfig = this.context.getToolConfiguration();
        Path targetDirectory = toolConfig.getAntennaTargetDirectory();
        return new File(targetDirectory.toFile(), "cyclonedx.bom.xml");
    }

    private void doGenerate(BomGenerator gen, File targetFile) throws ExecutionException {
        try {
            Document document = gen.generate();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            DOMSource source = new DOMSource(document);
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), StandardCharsets.UTF_8);){
                StreamResult result = new StreamResult(writer);
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                transformer.transform(source, result);
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            throw new ExecutionException("Unable to generate CycloneDX bom", (Throwable)e);
        }
    }

    private List<Component> toComponents(Collection<Artifact> artifacts) {
        LinkedHashSet<Component> components = new LinkedHashSet<Component>();
        for (Artifact artifact : artifacts) {
            components.add(ArtifactToComponentConverter.toComponent(artifact));
        }
        return new ArrayList<Component>(components);
    }
}

