/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.policy.testing;

import cucumber.api.java.en.Given;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.model.artifact.ArtifactFact;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactLicenseInformation;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactSoftwareHeritageID;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactSourceFile;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactSourceUrl;
import org.eclipse.sw360.antenna.model.artifact.facts.ConfiguredLicenseInformation;
import org.eclipse.sw360.antenna.model.artifact.facts.DeclaredLicenseInformation;
import org.eclipse.sw360.antenna.model.artifact.facts.ObservedLicenseInformation;
import org.eclipse.sw360.antenna.model.artifact.facts.OverriddenLicenseInformation;
import org.eclipse.sw360.antenna.model.coordinates.Coordinate;
import org.eclipse.sw360.antenna.model.license.License;
import org.eclipse.sw360.antenna.model.license.LicenseInformation;
import org.eclipse.sw360.antenna.model.license.LicenseOperator;
import org.eclipse.sw360.antenna.policy.testing.ScenarioState;
import org.eclipse.sw360.antenna.util.LicenseSupport;

public class GivenSteps {
    private ScenarioState state;
    private static final String LICENSES_PROP = "licenses";
    private static final String PROPRIETARY_PROP = "proprietary";
    private static final String COORDINATES_PROP = "coordinates";
    private static final String SOURCES_PROP = "sources";
    private static final String DECLARED_LICENSE_EXPRESSION = "Declared";
    private static final String OBSERVED_LICENSE_EXPRESSION = "Observed";
    private static final String OVERWRITTEN_LICENSE_EXPRESSION = "Overwritten";
    private static final String CONFIGURED_LICENSE_EXPRESSION = "Configured";
    private static final String SOFTWARE_HERITAGE_PROTOCOL = "swh";
    private static final String FILE_PROTOCOL = "file";
    private static final String URL_PROTOCOL = "http";
    private static final String FOLDERPREFIX = "AntennaPolicy";

    public GivenSteps(ScenarioState state) {
        this.state = state;
    }

    @Given(value="^an artifact$")
    public void an_artifact() {
        this.an_artifact_with("Default Name", Collections.emptyList());
    }

    @Given(value="^an artifact with$")
    public void an_artifact_with(List<List<String>> artifact_facts) {
        this.an_artifact_with("Default Name", artifact_facts);
    }

    @Given(value="^an artifact called \"([^\"]*)\" with$")
    public void an_artifact_with(String name, List<List<String>> artifact_facts) {
        Artifact artifact = new Artifact();
        this.mapArtifactFacts(artifact_facts, artifact);
        this.state.artifacts.put(name, artifact);
    }

    private void mapArtifactFacts(List<List<String>> artifact_facts, Artifact artifact) {
        artifact_facts.forEach(row -> this.mapProperty((List<String>)row, artifact));
    }

    private void mapProperty(List<String> row, Artifact artifact) {
        switch (this.getRowPropertyType(row)) {
            case "licenses": {
                this.addLicenseInformation(row, artifact);
                break;
            }
            case "proprietary": {
                artifact.setProprietary("true".equals(row.get(1)));
                break;
            }
            case "coordinates": {
                this.addCoordinates(row, artifact);
                break;
            }
            case "sources": {
                this.addSourceInfo(row, artifact);
                break;
            }
            default: {
                throw new IllegalArgumentException("Configuration Error: " + this.getRowPropertyType(row) + " is an unknown property for an artifact");
            }
        }
    }

    private String getRowPropertyType(List<String> row) {
        return row.get(0);
    }

    private void addLicenseInformation(List<String> row, Artifact artifact) {
        Optional<String> threatGroup = Optional.empty();
        if (row.size() >= 4) {
            threatGroup = Optional.ofNullable(row.get(3));
        }
        artifact.addFact((ArtifactFact)this.parseLicenseExpression(row.get(1), row.get(2), threatGroup));
    }

    private ArtifactLicenseInformation parseLicenseExpression(String licenseExpression, String expressionType, Optional<String> threatGroup) {
        if (licenseExpression.contains(" OR ")) {
            return this.createLicenseInformation(expressionType, this.createLicenseExpression(LicenseOperator.OR, licenseExpression.split(" OR ")));
        }
        if (licenseExpression.contains(" AND ")) {
            return this.createLicenseInformation(expressionType, this.createLicenseExpression(LicenseOperator.AND, licenseExpression.split(" AND ")));
        }
        return this.createLicenseInformation(expressionType, (LicenseInformation)this.createLicense(licenseExpression, threatGroup));
    }

    private LicenseInformation createLicenseExpression(LicenseOperator operator, String ... licenseExpressionParts) {
        return LicenseSupport.mapLicenses(Arrays.asList(licenseExpressionParts), (LicenseOperator)operator);
    }

    private License createLicense(String licenseExpression, Optional<String> threatGroup) {
        License license = new License();
        String[] licenseText = licenseExpression.split("::");
        license.setId(licenseText[0]);
        if (licenseText.length > 1) {
            license.setText(licenseText[1]);
        }
        threatGroup.ifPresent(arg_0 -> ((License)license).setThreatGroup(arg_0));
        return license;
    }

    private ArtifactLicenseInformation createLicenseInformation(String expressionType, LicenseInformation licenseExpression) {
        switch (expressionType) {
            case "Declared": {
                return new DeclaredLicenseInformation(licenseExpression);
            }
            case "Observed": {
                return new ObservedLicenseInformation(licenseExpression);
            }
            case "Overwritten": {
                return new OverriddenLicenseInformation(licenseExpression);
            }
            case "Configured": {
                return new ConfiguredLicenseInformation(licenseExpression);
            }
        }
        throw new IllegalArgumentException("Configuration Error: " + expressionType + " is not a defined license expression type");
    }

    private void addCoordinates(List<String> row, Artifact artifact) {
        artifact.addCoordinate(new Coordinate(row.get(1)));
    }

    private void addSourceInfo(List<String> row, Artifact artifact) {
        String sourceUrl = row.get(1);
        if (sourceUrl.startsWith(SOFTWARE_HERITAGE_PROTOCOL)) {
            artifact.addFact((ArtifactFact)new ArtifactSoftwareHeritageID.Builder(sourceUrl).build());
        } else if (sourceUrl.startsWith(FILE_PROTOCOL)) {
            try {
                boolean createFile = true;
                if (row.size() == 3) {
                    createFile = Boolean.parseBoolean(row.get(2));
                }
                String fileref = sourceUrl.split(":")[1];
                Path tempfolder = Files.createTempDirectory(FOLDERPREFIX, new FileAttribute[0]);
                Path testfile = Paths.get(tempfolder.toString(), fileref);
                if (createFile) {
                    testfile = Files.createFile(testfile, new FileAttribute[0]);
                }
                this.state.resourcesToDelete.add(tempfolder);
                artifact.addFact((ArtifactFact)new ArtifactSourceFile(testfile));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        } else if (sourceUrl.startsWith(URL_PROTOCOL)) {
            artifact.addFact((ArtifactFact)new ArtifactSourceUrl(sourceUrl));
        } else {
            throw new IllegalStateException("Cannot interpret sources information");
        }
    }
}

