/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.policy.testing;

import cucumber.api.java.en.When;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.sw360.antenna.policy.engine.Ruleset;
import org.eclipse.sw360.antenna.policy.testing.ScenarioState;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class WhenSteps {
    private ScenarioState state;

    public WhenSteps(ScenarioState state) {
        this.state = state;
    }

    @When(value="^I use the rule \"([^\"]*)\"$")
    public void i_use_the_rule(String rule) {
        Reflections searchEngine = new Reflections("", new Scanner[0]);
        Set rulesets = searchEngine.getSubTypesOf(Ruleset.class);
        Ruleset relevantRuleset = rulesets.stream().map(this::createRuleset).filter(rs -> this.containsRule((Ruleset)rs, rule)).findFirst().orElseThrow(IllegalStateException::new);
        this.state.rulesets = Arrays.asList(relevantRuleset.getClass().getName());
    }

    private boolean containsRule(Ruleset ruleset, String ruleId) {
        return ruleset.getRules().stream().anyMatch(rule -> ruleId.equalsIgnoreCase(rule.getId()));
    }

    private Ruleset createRuleset(Class<? extends Ruleset> rulesetclass) {
        try {
            return rulesetclass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }
}

