/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.policy.testing;

import cucumber.api.java.en.Then;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.eclipse.sw360.antenna.api.IEvaluationResult;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.policy.testing.ScenarioState;
import org.eclipse.sw360.antenna.policy.workflow.processors.PolicyEngineProcessor;

public class ThenSteps {
    private static final String RULESETCONFIGKEY = "ruleset.classes";
    private ScenarioState state;

    public ThenSteps(ScenarioState state) {
        this.state = state;
    }

    @Then(value="^the artifact called \"([^\"]*)\" should fail with policy id \"([^\"]*)\"$")
    public void the_artifact_should_fail(String name, String policy) {
        this.runRules();
        IEvaluationResult evaluationResult = this.findEvaluation(policy).orElseThrow(IllegalStateException::new);
        Assertions.assertThat((Iterable)evaluationResult.getFailedArtifacts()).hasSize(1);
        Assertions.assertThat((Iterable)evaluationResult.getFailedArtifacts()).containsExactly((Object[])new Artifact[]{this.state.artifacts.get(name)});
        this.deleteResources();
    }

    @Then(value="^the artifact should fail with policy id \"([^\"]*)\"$")
    public void the_artifact_should_fail(String policy) {
        this.runRules();
        IEvaluationResult evaluationResult = this.findEvaluation(policy).orElseThrow(IllegalStateException::new);
        Assertions.assertThat((Iterable)evaluationResult.getFailedArtifacts()).hasSize(1);
        Assertions.assertThat((Iterable)evaluationResult.getFailedArtifacts()).containsExactly((Object[])new Artifact[]{this.state.artifacts.get("Default Name")});
        this.deleteResources();
    }

    @Then(value="^all artifacts fail with policy id \"([^\"]*)\"$")
    public void all_artifacts_fail(String policy) {
        this.runRules();
        IEvaluationResult evaluationResult = this.findEvaluation(policy).orElseThrow(IllegalStateException::new);
        Assertions.assertThat((Iterable)evaluationResult.getFailedArtifacts()).hasSize(this.state.artifacts.size());
        this.deleteResources();
    }

    @Then(value="^no artifact fails on policy id \"([^\"]*)\"$")
    public void the_artifact_should_pass(String policy) {
        this.runRules();
        Assertions.assertThat((boolean)this.findEvaluation(policy).isPresent()).isFalse();
        this.deleteResources();
    }

    private Optional<IEvaluationResult> findEvaluation(String policy) {
        return this.state.evaluations.stream().filter(evaluation -> evaluation.getId().equals(policy)).findFirst();
    }

    private void runRules() {
        PolicyEngineProcessor testee = new PolicyEngineProcessor();
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put(RULESETCONFIGKEY, this.state.rulesets.stream().collect(Collectors.joining(",")));
        testee.configure(configMap);
        this.state.evaluations.addAll(testee.evaluate(this.state.artifacts.values()).getEvaluationResults());
    }

    private void deleteResources() {
        this.state.resourcesToDelete.forEach(this::deletePath);
    }

    private void deletePath(Path path) {
        try {
            Files.walk(path, new FileVisitOption[0]).map(Path::toFile).forEach(File::delete);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

