/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.frontend.stub.gradle;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.sw360.antenna.frontend.MetaDataStoringProject;
import org.eclipse.sw360.antenna.frontend.stub.cli.AbstractAntennaCLIFrontend;
import org.eclipse.sw360.antenna.frontend.stub.gradle.WrappedGradleProject;
import org.gradle.api.Project;

public class AntennaImpl {
    private final AbstractAntennaCLIFrontend antennaCLIFrontend;
    private final File pomFilePath;

    public AntennaImpl(String pluginDescendantArtifactIdName, Path pomFilePath, Project gradleProject) {
        this(pluginDescendantArtifactIdName, pomFilePath, gradleProject, null);
    }

    public AntennaImpl(final String pluginDescendantArtifactIdName, Path pomFilePath, Project gradleProject, Path propertiesFilePath) {
        this.pomFilePath = pomFilePath.toFile();
        final WrappedGradleProject wrappedGradleProject = this.getWrappedGradleProject(gradleProject, propertiesFilePath);
        this.antennaCLIFrontend = new AbstractAntennaCLIFrontend(this.pomFilePath){

            protected String getPluginDescendantArtifactIdName() {
                return pluginDescendantArtifactIdName;
            }

            protected Path getBuildDirFromFolder(Path folder) {
                return folder.resolve("build");
            }

            public MetaDataStoringProject getProject() {
                return wrappedGradleProject;
            }
        };
    }

    public void execute() {
        this.antennaCLIFrontend.execute();
    }

    private WrappedGradleProject getWrappedGradleProject(Project gradleProject, Path propertiesFilePath) {
        if (!this.pomFilePath.exists()) {
            throw new IllegalArgumentException("Cannot find " + this.pomFilePath.toString());
        }
        if (propertiesFilePath != null) {
            if (!Files.exists(propertiesFilePath, new LinkOption[0])) {
                throw new IllegalArgumentException("Cannot find " + propertiesFilePath.toString());
            }
            return new WrappedGradleProject(gradleProject, this.pomFilePath, propertiesFilePath.toFile());
        }
        return new WrappedGradleProject(gradleProject, this.pomFilePath);
    }
}

