/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.frontend.stub.gradle;

import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import org.eclipse.sw360.antenna.frontend.Build;
import org.eclipse.sw360.antenna.frontend.MetaDataStoringProject;
import org.gradle.api.Project;

public class WrappedGradleProject
extends MetaDataStoringProject {
    private final Project innerProject;
    private final Build build;
    private String projectId;
    private final File pomFile;

    public WrappedGradleProject(Project innerProject, File pomFile) {
        this(innerProject, pomFile, null);
    }

    public WrappedGradleProject(Project innerProject, File pomFile, File propertiesFile) {
        this.innerProject = innerProject;
        this.pomFile = pomFile;
        this.propertiesFile = propertiesFile;
        Path srcDir = innerProject.getRootDir().toPath().resolve("src").toAbsolutePath();
        Path buildDir = innerProject.getBuildDir().toPath().toAbsolutePath();
        this.build = new Build(buildDir.toString(), buildDir.resolve("classes").toString(), srcDir.resolve("main").resolve("java").toString(), srcDir.resolve("test").resolve("java").toString());
        this.projectId = innerProject.getName();
    }

    public File getBasedir() {
        return this.innerProject.getRootDir();
    }

    public Object getRawProject() {
        return this.innerProject;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getVersion() {
        return Optional.ofNullable(this.innerProject.getVersion()).filter(String.class::isInstance).map(String.class::cast).filter(v -> !v.isEmpty() && !"unspecified".equals(v)).orElse("1.0-SNAPSHOT");
    }

    public File getConfigFile() {
        return this.pomFile;
    }

    public String getBuildDirectory() {
        return this.innerProject.getBuildDir().getAbsolutePath();
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public void setVersion(String projectVersion) {
        this.innerProject.setVersion((Object)projectVersion);
    }

    public Build getBuild() {
        return this.build;
    }
}

