/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.http;

import java.net.InetSocketAddress;
import java.net.Proxy;
import okhttp3.OkHttpClient;
import org.eclipse.sw360.antenna.http.HttpClient;
import org.eclipse.sw360.antenna.http.HttpClientFactory;
import org.eclipse.sw360.antenna.http.HttpClientImpl;
import org.eclipse.sw360.antenna.http.config.HttpClientConfig;
import org.eclipse.sw360.antenna.http.config.ProxySettings;

public class HttpClientFactoryImpl
implements HttpClientFactory {
    @Override
    public HttpClient newHttpClient(HttpClientConfig config) {
        return new HttpClientImpl(HttpClientFactoryImpl.createClient(config), config.getOrCreateObjectMapper());
    }

    private static OkHttpClient createClient(HttpClientConfig config) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (config.proxySettings().isProxyUse()) {
            Proxy proxy = HttpClientFactoryImpl.createProxy(config.proxySettings());
            builder.proxy(proxy);
        }
        return builder.build();
    }

    private static Proxy createProxy(ProxySettings settings) {
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(settings.getProxyHost(), settings.getProxyPort()));
    }
}

