/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.http.config;

import java.util.Objects;

public final class ProxySettings {
    public static final String UNDEFINED_HOST = "";
    public static final int UNDEFINED_PORT = -1;
    private static final ProxySettings EMPTY_SETTINGS = new ProxySettings("", -1);
    private final String proxyHost;
    private final int proxyPort;

    private ProxySettings(String proxyHost, int proxyPort) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public static ProxySettings noProxy() {
        return EMPTY_SETTINGS;
    }

    public static ProxySettings useProxy(String host, int port) {
        return new ProxySettings(host, port);
    }

    public static ProxySettings fromConfig(boolean useProxy, String host, int port) {
        return useProxy && ProxySettings.settingsDefined(host, port) ? ProxySettings.useProxy(host, port) : ProxySettings.noProxy();
    }

    public boolean isProxyUse() {
        return ProxySettings.settingsDefined(this.proxyHost, this.proxyPort);
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxySettings settings = (ProxySettings)o;
        return this.getProxyPort() == settings.getProxyPort() && Objects.equals(this.getProxyHost(), settings.getProxyHost());
    }

    public int hashCode() {
        return Objects.hash(this.getProxyHost(), this.getProxyPort());
    }

    public String toString() {
        return "ProxySettings{, proxyHost='" + this.proxyHost + '\'' + ", proxyPort=" + this.proxyPort + '}';
    }

    private static boolean settingsDefined(String proxyHost, int proxyPort) {
        return proxyPort != -1 && proxyHost != null && !proxyHost.equals(UNDEFINED_HOST);
    }
}

