/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.eclipse.sw360.antenna.http.HttpClient;
import org.eclipse.sw360.antenna.http.RequestBuilder;
import org.eclipse.sw360.antenna.http.RequestBuilderImpl;
import org.eclipse.sw360.antenna.http.ResponseImpl;
import org.eclipse.sw360.antenna.http.ResponseProcessor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpClientImpl
implements HttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientImpl.class);
    private final OkHttpClient client;
    private final ObjectMapper mapper;

    public HttpClientImpl(OkHttpClient client, ObjectMapper mapper) {
        this.client = client;
        this.mapper = mapper;
    }

    @Override
    public <T> CompletableFuture<T> execute(Consumer<? super RequestBuilder> producer, ResponseProcessor<? extends T> processor) {
        RequestBuilderImpl builder = new RequestBuilderImpl(this.getMapper());
        producer.accept(builder);
        CompletableFuture resultFuture = new CompletableFuture();
        Request request = builder.build();
        LOG.debug("HTTP request {} {}", (Object)request.method(), (Object)request.url());
        this.getClient().newCall(request).enqueue(this.createCallback(processor, resultFuture));
        return resultFuture;
    }

    <T> Callback createCallback(final ResponseProcessor<? extends T> processor, final CompletableFuture<T> resultFuture) {
        return new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                resultFuture.completeExceptionally(e);
                LOG.error("Failed HTTP request {} {}", new Object[]{call.request().method(), call.request().url(), e});
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) {
                try {
                    LOG.debug("HTTP response {} - {} {}", new Object[]{response.code(), response.request().method(), response.request().url()});
                    Object result = processor.process(new ResponseImpl(response));
                    resultFuture.complete(result);
                }
                catch (Exception e) {
                    resultFuture.completeExceptionally(e);
                    LOG.error("Failed HTTP request {} {}", new Object[]{call.request().method(), call.request().url(), e});
                }
                finally {
                    response.close();
                }
            }
        };
    }

    OkHttpClient getClient() {
        return this.client;
    }

    ObjectMapper getMapper() {
        return this.mapper;
    }
}

