/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.http;

import java.net.InetSocketAddress;
import java.net.Proxy;
import okhttp3.OkHttpClient;
import org.eclipse.sw360.antenna.http.HttpClient;
import org.eclipse.sw360.antenna.http.HttpClientFactory;
import org.eclipse.sw360.antenna.http.HttpClientImpl;
import org.eclipse.sw360.antenna.http.config.HttpClientConfig;
import org.eclipse.sw360.antenna.http.config.ProxySettings;

public class HttpClientFactoryImpl
implements HttpClientFactory {
    static final String CLIENT_ACCESS_UNVERIFIED_PROPERTY = "client.access.unverified";

    @Override
    public HttpClient newHttpClient(HttpClientConfig config) {
        return new HttpClientImpl(HttpClientFactoryImpl.createClient(config), config.getOrCreateObjectMapper());
    }

    private static OkHttpClient createClient(HttpClientConfig config) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (!config.proxySettings().isDefaultProxySelectorUse()) {
            Proxy proxy = config.proxySettings().isNoProxy() ? Proxy.NO_PROXY : HttpClientFactoryImpl.createProxy(config.proxySettings());
            builder.proxy(proxy);
        }
        if (HttpClientFactoryImpl.unverifiedSSLCertificate()) {
            builder.hostnameVerifier((s, sslSession) -> true);
        }
        return builder.build();
    }

    private static boolean unverifiedSSLCertificate() {
        return Boolean.parseBoolean(System.getProperty(CLIENT_ACCESS_UNVERIFIED_PROPERTY));
    }

    private static Proxy createProxy(ProxySettings settings) {
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(settings.getProxyHost(), settings.getProxyPort()));
    }
}

