/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.nio.file.Path;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.eclipse.sw360.antenna.http.RequestBodyBuilder;

class RequestBodyBuilderImpl
implements RequestBodyBuilder {
    private final ObjectMapper mapper;
    private RequestBody body;
    private String fileName;

    public RequestBodyBuilderImpl(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void string(String str, String mediaType) {
        this.initBody(RequestBody.create((String)str, (MediaType)MediaType.parse((String)mediaType)));
    }

    @Override
    public void file(Path path, String mediaType) {
        this.initBody(RequestBody.create((File)path.toFile(), (MediaType)MediaType.parse((String)mediaType)));
        Path fileNamePath = path.getFileName();
        this.fileName = fileNamePath != null ? fileNamePath.toString() : null;
    }

    @Override
    public void json(Object payload) {
        try {
            this.string(this.mapper.writeValueAsString(payload), "application/json");
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public RequestBody getBody() {
        if (this.body == null) {
            throw new IllegalStateException("A RequestBodyBuilder was requested, but no body was defined.");
        }
        return this.body;
    }

    public String getFileName() {
        return this.fileName;
    }

    private void initBody(RequestBody b) {
        if (this.body != null) {
            throw new IllegalStateException("Multiple body definitions. Only a single request body can be defined using a RequestBodyBuilder.");
        }
        this.body = b;
    }
}

