/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.http.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.sw360.antenna.http.config.ProxySettings;

public final class HttpClientConfig {
    private static final HttpClientConfig BASIC_CONFIG = new HttpClientConfig(null, ProxySettings.defaultProxySelector());
    private final ObjectMapper customObjectMapper;
    private final ProxySettings proxySettings;

    private HttpClientConfig(ObjectMapper customObjectMapper, ProxySettings proxySettings) {
        this.customObjectMapper = customObjectMapper;
        this.proxySettings = proxySettings;
    }

    public static HttpClientConfig basicConfig() {
        return BASIC_CONFIG;
    }

    public Optional<ObjectMapper> customObjectMapper() {
        return Optional.ofNullable(this.customObjectMapper);
    }

    public ObjectMapper getOrCreateObjectMapper() {
        return this.customObjectMapper().orElseGet(ObjectMapper::new);
    }

    public ProxySettings proxySettings() {
        return this.proxySettings;
    }

    public HttpClientConfig withObjectMapper(ObjectMapper newMapper) {
        return new HttpClientConfig(newMapper, this.proxySettings);
    }

    public HttpClientConfig withProxySettings(ProxySettings newProxySettings) {
        return new HttpClientConfig(this.customObjectMapper, newProxySettings);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpClientConfig that = (HttpClientConfig)o;
        return Objects.equals(this.customObjectMapper, that.customObjectMapper) && Objects.equals(this.proxySettings, that.proxySettings);
    }

    public int hashCode() {
        return Objects.hash(this.customObjectMapper, this.proxySettings);
    }
}

