/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.http.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.eclipse.sw360.antenna.http.RequestBuilder;
import org.eclipse.sw360.antenna.http.Response;
import org.eclipse.sw360.antenna.http.ResponseProcessor;
import org.eclipse.sw360.antenna.http.utils.FailedRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpUtils {
    public static final Predicate<Response> SUCCESS_STATUS = Response::isSuccess;
    private static final String PARAMETER_SEPARATOR = "&";
    private static final char KEY_VALUE_SEPARATOR = '=';
    private static final char QUERY_PREFIX = '?';
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpUtils.class);

    private HttpUtils() {
    }

    public static <T> T waitFor(Future<? extends T> future) throws IOException {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            throw HttpUtils.wrapInIOException(e.getCause());
        }
    }

    public static Throwable unwrapCompletionException(Throwable ex) {
        Throwable cause = ex;
        while (cause instanceof CompletionException) {
            cause = cause.getCause();
        }
        return cause;
    }

    public static boolean isSuccessStatus(int status) {
        return status >= 200 && status < 300;
    }

    public static <T> ResponseProcessor<T> checkResponse(ResponseProcessor<T> processor, Predicate<Response> successPredicate, String tag) {
        return response -> {
            if (!successPredicate.test(response)) {
                throw HttpUtils.createExceptionForResponse(response, tag);
            }
            return processor.process(response);
        };
    }

    public static <T> ResponseProcessor<T> checkResponse(ResponseProcessor<T> processor, Predicate<Response> successPredicate) {
        return HttpUtils.checkResponse(processor, successPredicate, null);
    }

    public static <T> ResponseProcessor<T> checkResponse(ResponseProcessor<T> processor, String tag) {
        return HttpUtils.checkResponse(processor, SUCCESS_STATUS, tag);
    }

    public static <T> ResponseProcessor<T> checkResponse(ResponseProcessor<T> processor) {
        return HttpUtils.checkResponse(processor, SUCCESS_STATUS);
    }

    public static Predicate<Response> hasStatus(int status) {
        return response -> response.statusCode() == status;
    }

    public static FailedRequestException createExceptionForResponse(Response response, String tag) {
        StringBuilder buf = new StringBuilder();
        InputStream bodyStream = response.bodyStream();
        if (bodyStream != null) {
            try (InputStreamReader reader = new InputStreamReader(bodyStream, StandardCharsets.UTF_8);){
                IOUtils.copy((Reader)reader, (Appendable)buf);
            }
            catch (IOException e) {
                LOGGER.warn("Could not read server message when handling failed request '{}'.", (Object)tag, (Object)e);
            }
        }
        return new FailedRequestException(tag, response.statusCode(), buf.toString());
    }

    public static <T> ResponseProcessor<T> jsonResult(ObjectMapper mapper, Class<T> resultClass) {
        return response -> mapper.readValue(response.bodyStream(), resultClass);
    }

    public static <T> ResponseProcessor<T> jsonResult(ObjectMapper mapper, TypeReference<T> typeReference) {
        return response -> mapper.readValue(response.bodyStream(), typeReference);
    }

    public static Consumer<RequestBuilder> get(String uri) {
        return builder -> builder.uri(uri);
    }

    public static <T> ResponseProcessor<T> nullProcessor() {
        return response -> null;
    }

    public static String urlEncode(String src) {
        if (src == null) {
            return null;
        }
        try {
            return URLEncoder.encode(src, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 charset not supported!");
        }
    }

    public static String addQueryParameters(String url, Map<String, ?> params) {
        return HttpUtils.addQueryParameters(url, params, false);
    }

    public static String addQueryParameters(String url, Map<String, ?> params, boolean filterUndefined) {
        if (url == null) {
            throw new NullPointerException("URL must not be null");
        }
        String paramStr = params.entrySet().stream().filter(entry -> !filterUndefined || HttpUtils.isParameterDefined(entry.getValue())).map(entry -> HttpUtils.encodeQueryParameter((String)entry.getKey(), entry.getValue())).collect(Collectors.joining(PARAMETER_SEPARATOR));
        return paramStr.isEmpty() ? url : url + '?' + paramStr;
    }

    public static String addQueryParameter(String url, String key, Object value) {
        return HttpUtils.addQueryParameters(url, Collections.singletonMap(key, value));
    }

    private static IOException wrapInIOException(Throwable e) {
        return e instanceof IOException ? (IOException)e : new IOException(e);
    }

    private static String encodeQueryParameter(String key, Object value) {
        String encValue = value == null ? "" : HttpUtils.urlEncode(value.toString());
        return HttpUtils.urlEncode(key) + '=' + encValue;
    }

    private static boolean isParameterDefined(Object value) {
        return value != null && !value.toString().isEmpty();
    }
}

