/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.frontend.stub.mojo;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.eclipse.sw360.antenna.api.IAttachable;
import org.eclipse.sw360.antenna.api.IProcessingReporter;
import org.eclipse.sw360.antenna.api.IProject;
import org.eclipse.sw360.antenna.api.configuration.AntennaContext;
import org.eclipse.sw360.antenna.api.configuration.ToolConfiguration;
import org.eclipse.sw360.antenna.api.exceptions.ConfigurationException;
import org.eclipse.sw360.antenna.api.exceptions.ExecutionException;
import org.eclipse.sw360.antenna.core.AntennaCore;
import org.eclipse.sw360.antenna.frontend.AntennaFrontend;
import org.eclipse.sw360.antenna.frontend.AntennaFrontendHelper;
import org.eclipse.sw360.antenna.frontend.stub.mojo.ArtifactAttacher;
import org.eclipse.sw360.antenna.frontend.stub.mojo.InlineWorkflowParsingResult;
import org.eclipse.sw360.antenna.maven.WrappedDependencyNodes;
import org.eclipse.sw360.antenna.maven.WrappedMavenProject;
import org.eclipse.sw360.antenna.model.xml.generated.Workflow;
import org.eclipse.sw360.antenna.util.TemplateRenderer;
import org.eclipse.sw360.antenna.workflow.WorkflowFileLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAntennaMojoFrontend
extends AbstractMojo
implements AntennaFrontend<WrappedMavenProject> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAntennaMojoFrontend.class);
    private final Map<String, IAttachable> output = new HashMap<String, IAttachable>();
    private WrappedMavenProject wrappedMavenProject;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Component
    private LegacySupport mvnBuildContext;
    @Component
    private ArtifactResolver mvnArtifactResolver;
    @Component
    private RepositorySystem mvnRepositorySystem;
    @Component
    private MavenProjectHelper attachHelper;
    @Parameter(property="antennaTargetDirectory", defaultValue="${project.build.directory}${file.separator}antenna")
    private String antennaTargetDirectory;
    @Parameter(property="configFiles")
    private List<File> configFiles;
    @Parameter(property="configFileUri")
    private List<URI> configFileUris;
    @Parameter(property="attachAll", defaultValue="false")
    private boolean attachAll;
    @Parameter(property="skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="fullname", defaultValue="${project.name}")
    private String productFullname;
    @Parameter(property="version", defaultValue="1.0")
    private String version;
    @Parameter(property="productName", defaultValue="${project.artifactId}")
    private String productName;
    @Parameter(property="companyName")
    private String companyName;
    @Parameter(property="copyrightHoldersName")
    private String copyrightHoldersName;
    @Parameter(property="copyrightNotice")
    private String copyrightNotice;
    @Parameter(property="attributionDocumentNotes")
    private String attributionDocumentNotes;
    @Parameter(property="filesToAttach")
    private List<String> filesToAttach;
    @Parameter(property="workflowDefinitionFile")
    private String workflowDefinitionFile;
    @Parameter(property="workflow")
    private Workflow workflow;
    @Parameter(property="showCopyrightStatements", defaultValue="false")
    private boolean showCopyrightStatements;
    @Parameter(property="encodingCharSet", defaultValue="UTF-8")
    private String encodingCharSet;
    @Parameter(property="proxyHost", defaultValue="")
    private String proxyHost;
    @Parameter(property="proxyPort", defaultValue="0")
    private int proxyPort;
    @Parameter(property="proxyId", defaultValue="")
    private String proxyId;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;
    @Component(hint="default", role=DependencyGraphBuilder.class)
    private DependencyGraphBuilder dependencyGraphBuilder;

    private void getProxySettingsFromSettings() {
        boolean noProxyIsYetConfigured = this.proxyHost == null || "".equals(this.proxyHost) || this.proxyPort <= 0;
        Predicate<Proxy> proxyContainsUnsupportedConfiguration = proxy -> proxy.getUsername() != null && !"".equals(proxy.getUsername()) || proxy.getPassword() != null && !"".equals(proxy.getPassword()) || proxy.getNonProxyHosts() != null && !"".equals(proxy.getNonProxyHosts());
        if (noProxyIsYetConfigured) {
            this.settings.getProxies().stream().filter(Proxy::isActive).peek(proxy -> {
                if (!"http".equals(proxy.getProtocol())) {
                    LOGGER.warn("Maven settings contain proxy with unsupportet protocol=[" + proxy.getProtocol() + "]");
                }
            }).filter(proxy -> "http".equals(proxy.getProtocol())).filter(proxy -> "".equals(this.proxyId) || proxy.getId().equals(this.proxyId)).peek(proxy -> {
                if (proxyContainsUnsupportedConfiguration.test((Proxy)proxy)) {
                    LOGGER.warn("Maven settings contain proxy configuration which can not be handled by antenna completely (e.g. authentication, nonProxyHosts)");
                }
            }).forEach(proxy -> {
                if (proxy.getHost() != null && !"".equals(proxy.getHost()) && proxy.getPort() > 0) {
                    LOGGER.debug("Use proxy configuration with id=[" + proxy.getId() + "] from Maven settings");
                    this.proxyHost = proxy.getHost();
                    this.proxyPort = proxy.getPort();
                }
            });
        }
    }

    public void execute() throws MojoExecutionException {
        AntennaCore antennaCore;
        AntennaContext context;
        try {
            AntennaFrontendHelper antennaFrontendHelper = this.init();
            context = antennaFrontendHelper.buildAntennaContext();
            antennaCore = antennaFrontendHelper.buildAntennaCore(context);
        }
        catch (ConfigurationException e) {
            LOGGER.error("AntennaCore was not initialized sucessfully");
            throw new MojoExecutionException("Exception during Antenna initialization", (Exception)((Object)e));
        }
        try {
            this.output.putAll(antennaCore.compose());
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("Exception during Antenna execution", (Exception)((Object)e));
        }
        finally {
            IAttachable report = antennaCore.writeAnalysisReport();
            this.output.put(IProcessingReporter.getIdentifier(), report);
            LOGGER.debug("Attaching artifacts to project");
            ArtifactAttacher attacher = new ArtifactAttacher(context);
            attacher.attach(this.output);
            LOGGER.debug("Attaching artifacts to project..done");
        }
    }

    public AntennaFrontendHelper init() {
        this.getProxySettingsFromSettings();
        ToolConfiguration toolConfiguration = this.loadConfiguration();
        this.wrappedMavenProject = new WrappedMavenProject(this.mvnBuildContext.getSession().getCurrentProject());
        WrappedDependencyNodes wrappedDependencyNodes = this.getWrappedDependencyNodes();
        return new AntennaFrontendHelper((IProject)this.wrappedMavenProject).setToolConfiguration(toolConfiguration).putGeneric((Object)this.attachHelper).putGeneric((Object)this.mvnArtifactResolver).putGeneric((Object)this.project).putGeneric((Object)this.settings).putGeneric((Object)this.mvnBuildContext).putGeneric((Object)this.mvnRepositorySystem).putGeneric((Object)wrappedDependencyNodes);
    }

    public WrappedMavenProject getProject() {
        return this.wrappedMavenProject;
    }

    private ToolConfiguration loadConfiguration() {
        Workflow finalWorkflow;
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        contextMap.put("project", this.project);
        contextMap.put("basedir", this.project.getBasedir().toPath().toString());
        System.getProperties().entrySet().stream().filter(e -> e.getKey().toString().startsWith("proxy")).forEach(e -> contextMap.put(e.getKey().toString(), e.getValue().toString()));
        TemplateRenderer tr = new TemplateRenderer(contextMap);
        Optional<File> workflowDefFile = Optional.ofNullable(this.workflowDefinitionFile).map(File::new);
        try {
            finalWorkflow = WorkflowFileLoader.loadWorkflowFromClassPath(workflowDefFile, (TemplateRenderer)tr);
            WorkflowFileLoader.overrideWorkflow((Workflow)finalWorkflow, (Workflow)this.workflow);
        }
        catch (ConfigurationException e2) {
            throw new ExecutionException("Failed to load workflow", (Throwable)e2);
        }
        ToolConfiguration.ConfigurationBuilder toolConfigBuilder = new ToolConfiguration.ConfigurationBuilder().setAntennaTargetDirectory(this.antennaTargetDirectory).setAttachAll(this.attachAll).setFilesToAttach(this.filesToAttach).setConfigFiles(this.configFiles).setConfigFileUris(this.configFileUris).setProductName(this.productName).setProductFullName(this.productFullname).setVersion(this.version).setSkipAntennaExecution(this.skip).setMavenInstalled(true).setCopyrightHoldersName(this.copyrightHoldersName).setCopyrightNotice(this.copyrightNotice).setAttributionDocumentNotes(this.attributionDocumentNotes).setWorkflow(finalWorkflow).setProxyHost(this.proxyHost).setProxyPort(this.proxyPort).setShowCopyrightStatements(this.showCopyrightStatements).setEncoding(this.encodingCharSet);
        return toolConfigBuilder.buildConfiguration();
    }

    private WrappedDependencyNodes getWrappedDependencyNodes() {
        WrappedDependencyNodes wrappedDependencyNodes = null;
        if (this.dependencyGraphBuilder != null) {
            try {
                MavenSession session = this.mvnBuildContext.getSession();
                DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(session.getProjectBuildingRequest());
                buildingRequest.setProject(session.getCurrentProject());
                DependencyNode dependencyNode = this.dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)buildingRequest, null);
                CollectingDependencyNodeVisitor visitor = new CollectingDependencyNodeVisitor();
                dependencyNode.accept((DependencyNodeVisitor)visitor);
                wrappedDependencyNodes = new WrappedDependencyNodes(visitor.getNodes());
            }
            catch (DependencyGraphBuilderException e) {
                LOGGER.error(String.format("Could not build maven dependency tree: %s", e.getMessage()));
            }
        }
        return wrappedDependencyNodes;
    }

    public Map<String, IAttachable> getOutputs() {
        return this.output;
    }

    public void setWorkflow(InlineWorkflowParsingResult workflowParsingResult) {
        this.warnIfWorkflowIsPotentiallyWrong(workflowParsingResult);
        this.workflow = workflowParsingResult;
    }

    private void warnIfWorkflowIsPotentiallyWrong(Workflow workflowParsingResult) {
        boolean isPotentiallyWrong = Stream.of(workflowParsingResult.getAnalyzers().getStep(), workflowParsingResult.getGenerators().getStep(), workflowParsingResult.getProcessors().getStep(), workflowParsingResult.getOutputHandlers().getStep()).flatMap(Collection::stream).flatMap(workflowStep -> workflowStep.getConfiguration().getEntry().stream()).anyMatch(entry -> entry.getKey() == null && entry.getEntryKey() == null || entry.getValue() == null && entry.getEntryValue() == null);
        if (isPotentiallyWrong) {
            String msg = "The parsed workflow in the pom contains workflow configuration entries without key or without value.\nThis is a strong hint that the configuration uses the wrong format:\n\tinstead of the short format with attributes, i.e.\n\t\t<entry key=\"somKey\" value=\"someValue\"/>\n\tone has to use the alternative format:\n\t\t<entry><entryKey>someKey</entryKey><entryValue>someValue</entryValue></entry>";
            LOGGER.warn(msg);
        }
    }
}

