/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.frontend.stub.mojo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.sw360.antenna.api.IAttachable;
import org.eclipse.sw360.antenna.api.IProcessingReporter;
import org.eclipse.sw360.antenna.api.configuration.AntennaContext;
import org.eclipse.sw360.antenna.api.configuration.ToolConfiguration;
import org.eclipse.sw360.antenna.api.exceptions.ExecutionException;
import org.eclipse.sw360.antenna.model.reporting.MessageType;
import org.eclipse.sw360.antenna.model.reporting.ProcessingMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactAttacher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactAttacher.class);
    private IProcessingReporter reporter;
    private MavenProjectHelper projectHelper;
    private MavenProject currentProject;
    private boolean attachAll;
    private final ToolConfiguration toolConf;
    private boolean isSupported = true;

    public ArtifactAttacher(AntennaContext context) {
        this.toolConf = context.getToolConfiguration();
        if (context.getProject().getRawProject() instanceof MavenProject) {
            this.reporter = context.getProcessingReporter();
            this.projectHelper = (MavenProjectHelper)context.getGeneric(MavenProjectHelper.class).orElseThrow(() -> new ExecutionException("MavenProjectHelper is not supported "));
            this.currentProject = (MavenProject)context.getProject().getRawProject();
            this.attachAll = this.toolConf.isAttachAll();
        } else {
            this.isSupported = false;
        }
    }

    public void attach(Map<String, IAttachable> artifactsToAttach) {
        Predicate<Map.Entry> filterFunc;
        if (!this.isSupported) {
            LOGGER.warn("Tried to attach artifacts, but artifact attaching is not supported");
            return;
        }
        if (this.attachAll) {
            filterFunc = key -> true;
        } else {
            Map<String, String[]> fileMap = this.createFilesToAttach(this.toolConf.getFilesToAttach());
            filterFunc = key -> fileMap.containsKey(key.getKey());
        }
        artifactsToAttach.entrySet().stream().filter(filterFunc).forEach(a -> this.attachArtifact((IAttachable)a.getValue()));
    }

    private void attachArtifact(IAttachable attachable) {
        LOGGER.debug("Attaching artifact {}", (Object)attachable.getFile());
        try {
            this.projectHelper.attachArtifact(this.currentProject, attachable.getType(), attachable.getClassifier(), attachable.getFile());
        }
        catch (Exception e) {
            ProcessingMessage message = new ProcessingMessage(MessageType.ATTACHING_FAILURE, attachable.getClassifier(), String.format("The artifact %s couldn't be attached to the project: %s", attachable.getClassifier(), e.getMessage()));
            this.reporter.add(message);
        }
    }

    private Map<String, String[]> createFilesToAttach(List<String> filesToAttach) {
        HashMap<String, String[]> fileInformation = new HashMap<String, String[]>();
        for (String string : filesToAttach) {
            String[] split = string.split(",");
            if (split.length == 3) {
                fileInformation.put(split[0], new String[]{split[1], split[2]});
                continue;
            }
            LOGGER.warn("Wrong input were supplied to filesToAttach [{}]", (Object)string);
        }
        return fileInformation;
    }
}

