/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.maven;

import java.io.File;
import java.net.URL;
import java.util.Optional;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.eclipse.sw360.antenna.http.HttpClient;
import org.eclipse.sw360.antenna.maven.HttpRequester;
import org.eclipse.sw360.antenna.maven.IArtifactRequester;
import org.eclipse.sw360.antenna.maven.MavenInvokerRequester;
import org.eclipse.sw360.antenna.maven.MavenRuntimeRequester;

public class ArtifactRequesterFactory {
    public static IArtifactRequester getArtifactRequester(Optional<RepositorySystem> optionalRepositorySystem, Optional<MavenProject> optionalMavenProject, Optional<LegacySupport> optionalLegacySupport, File basedir, HttpClient httpClient, boolean isMavenInstalled, URL sourcesRepositoryUrl) {
        if (isMavenInstalled) {
            return ArtifactRequesterFactory.useMavenIfRunning(optionalRepositorySystem, optionalMavenProject, optionalLegacySupport, Optional.of(sourcesRepositoryUrl)).orElse(new MavenInvokerRequester(basedir, sourcesRepositoryUrl));
        }
        return new HttpRequester(httpClient, sourcesRepositoryUrl);
    }

    public static IArtifactRequester getArtifactRequester(Optional<RepositorySystem> optionalRepositorySystem, Optional<MavenProject> optionalMavenProject, Optional<LegacySupport> optionalLegacySupport, File basedir, HttpClient httpClient, boolean isMavenInstalled) {
        if (isMavenInstalled) {
            return ArtifactRequesterFactory.useMavenIfRunning(optionalRepositorySystem, optionalMavenProject, optionalLegacySupport, Optional.empty()).orElse(new MavenInvokerRequester(basedir));
        }
        return new HttpRequester(httpClient);
    }

    private static Optional<IArtifactRequester> useMavenIfRunning(Optional<RepositorySystem> optionalRepositorySystem, Optional<MavenProject> optionalMavenProject, Optional<LegacySupport> optionalLegacySupport, Optional<URL> sourcesRepositoryUrl) {
        ArtifactRepository localRepository;
        if (optionalRepositorySystem.isPresent() && optionalMavenProject.isPresent() && optionalLegacySupport.isPresent() && (localRepository = optionalLegacySupport.get().getSession().getLocalRepository()) != null) {
            return Optional.of(new MavenRuntimeRequester(optionalRepositorySystem.get(), localRepository, optionalMavenProject.get().getRemoteArtifactRepositories(), sourcesRepositoryUrl));
        }
        return Optional.empty();
    }
}

