/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.maven.workflow.processors.enricher;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.eclipse.sw360.antenna.api.configuration.ToolConfiguration;
import org.eclipse.sw360.antenna.api.exceptions.ConfigurationException;
import org.eclipse.sw360.antenna.api.workflow.AbstractProcessor;
import org.eclipse.sw360.antenna.maven.workflow.processors.enricher.MavenArtifactResolverImpl;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.model.artifact.ArtifactSelector;

public class MavenArtifactResolver
extends AbstractProcessor {
    private static final String PREFERRED_SOURCE_QUALIFIER = "preferredSourceClassifier";
    private static final String SOURCES_REPOSITORY_URL = "sourcesRepositoryUrl";
    private Path dependencyTargetDirectory;
    private List<ArtifactSelector> sourceResolvingBlacklist;
    private String preferredSourceQualifier;
    private URL sourcesRepositoryUrl;

    public MavenArtifactResolver() {
        this.workflowStepOrder = (short)300;
    }

    public Collection<Artifact> process(Collection<Artifact> artifacts) {
        ToolConfiguration toolConfig = this.context.getToolConfiguration();
        return new MavenArtifactResolverImpl(this.context.getHttpClient(), this.context.getGeneric(RepositorySystem.class), this.context.getGeneric(MavenProject.class), this.context.getGeneric(LegacySupport.class), this.dependencyTargetDirectory, this.sourceResolvingBlacklist, this.preferredSourceQualifier, this.sourcesRepositoryUrl, this.context.getProcessingReporter(), toolConfig.isMavenInstalled(), this.context.getProject().getBasedir()).process(artifacts);
    }

    public void configure(Map<String, String> configMap) {
        this.dependencyTargetDirectory = this.context.getToolConfiguration().getDependenciesDirectory();
        this.sourceResolvingBlacklist = this.context.getConfiguration().getIgnoreForSourceResolving();
        String sourcesUrlString = configMap.get(SOURCES_REPOSITORY_URL);
        if (sourcesUrlString != null) {
            try {
                this.sourcesRepositoryUrl = new URL(sourcesUrlString);
            }
            catch (MalformedURLException e) {
                throw new ConfigurationException("The URL in 'sourcesRepositoryUrl' is not valid.");
            }
        }
        this.preferredSourceQualifier = configMap.get(PREFERRED_SOURCE_QUALIFIER);
    }
}

