/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.maven.workflow.processors.enricher;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.eclipse.sw360.antenna.api.IProcessingReporter;
import org.eclipse.sw360.antenna.api.exceptions.ExecutionException;
import org.eclipse.sw360.antenna.http.HttpClient;
import org.eclipse.sw360.antenna.maven.ArtifactRequesterFactory;
import org.eclipse.sw360.antenna.maven.ClassifierInformation;
import org.eclipse.sw360.antenna.maven.IArtifactRequester;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.model.artifact.ArtifactFact;
import org.eclipse.sw360.antenna.model.artifact.ArtifactSelector;
import org.eclipse.sw360.antenna.model.artifact.facts.java.ArtifactJar;
import org.eclipse.sw360.antenna.model.artifact.facts.java.ArtifactSourceJar;
import org.eclipse.sw360.antenna.model.coordinates.Coordinate;
import org.eclipse.sw360.antenna.model.reporting.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenArtifactResolverImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenArtifactResolverImpl.class);
    private final IProcessingReporter processingReporter;
    private final Path dependencyTargetDirectory;
    private final List<ArtifactSelector> sourceResolvingBlacklist;
    private final String preferredSourceQualifier;
    private final URL sourcesRepositoryUrl;
    private final HttpClient httpClient;
    private final Optional<RepositorySystem> optionalRepositorySystem;
    private final Optional<MavenProject> optionalMavenProject;
    private final Optional<LegacySupport> optionalLegacySupport;
    private final boolean isMavenInstalled;
    private final File basedir;

    public MavenArtifactResolverImpl(HttpClient httpClient, Optional<RepositorySystem> optionalRepositorySystem, Optional<MavenProject> optionalMavenProject, Optional<LegacySupport> optionalLegacySupport, Path dependencyTargetDirectory, List<ArtifactSelector> sourceResolvingBlacklist, String preferredSourceQualifier, URL sourcesRepositoryUrl, IProcessingReporter processingReporter, boolean isMavenInstalled, File basedir) {
        this.dependencyTargetDirectory = dependencyTargetDirectory;
        this.sourceResolvingBlacklist = sourceResolvingBlacklist;
        this.sourcesRepositoryUrl = sourcesRepositoryUrl;
        this.preferredSourceQualifier = preferredSourceQualifier;
        this.processingReporter = processingReporter;
        this.httpClient = httpClient;
        this.optionalRepositorySystem = optionalRepositorySystem;
        this.optionalMavenProject = optionalMavenProject;
        this.optionalLegacySupport = optionalLegacySupport;
        this.isMavenInstalled = isMavenInstalled;
        this.basedir = basedir;
    }

    public Collection<Artifact> process(Collection<Artifact> artifacts) {
        LOGGER.info("Resolving Maven artifacts, please be patient...");
        try {
            this.resolveArtifacts(artifacts);
            LOGGER.info("Resolving Maven artifacts succeeded.");
        }
        catch (IOException e) {
            throw new ExecutionException("Resolving Maven artifacts failed.", (Throwable)e);
        }
        return artifacts;
    }

    private void resolveArtifacts(Collection<Artifact> artifacts) throws IOException {
        if (!Files.isDirectory(this.dependencyTargetDirectory, new LinkOption[0])) {
            Files.createDirectories(this.dependencyTargetDirectory, new FileAttribute[0]);
        }
        IArtifactRequester artifactRequester = this.getArtifactRequester();
        List filteredArtifacts = artifacts.stream().filter(this.getFilterPredicate()).filter(artifact -> !this.isIgnoredForSourceResolving((Artifact)artifact)).collect(Collectors.toList());
        for (Artifact artifact2 : filteredArtifacts) {
            this.resolve(artifact2, artifactRequester, this.dependencyTargetDirectory);
        }
    }

    private void resolve(Artifact artifact, IArtifactRequester artifactRequester, Path dependencyTargetDirectory) {
        Optional<File> sourceJar;
        Optional oMavenPurl = artifact.getCoordinateForType("maven");
        if (!oMavenPurl.isPresent()) {
            return;
        }
        Coordinate coordinate = (Coordinate)oMavenPurl.get();
        if (coordinate.getName() == null || coordinate.getNamespace() == null || !"maven".equals(coordinate.getType())) {
            return;
        }
        if (!artifact.getSourceFile().isPresent() && this.preferredSourceQualifier != null) {
            sourceJar = artifactRequester.requestFile(coordinate, dependencyTargetDirectory, new ClassifierInformation(this.preferredSourceQualifier, true));
            sourceJar.ifPresent(sourceJarFile -> artifact.addFact((ArtifactFact)new ArtifactSourceJar(sourceJarFile.toPath())));
        }
        if (!artifact.getSourceFile().isPresent()) {
            sourceJar = artifactRequester.requestFile(coordinate, dependencyTargetDirectory, ClassifierInformation.DEFAULT_SOURCE_JAR);
            sourceJar.ifPresent(sourceJarFile -> artifact.addFact((ArtifactFact)new ArtifactSourceJar(sourceJarFile.toPath())));
        }
        if (!artifact.getFile().isPresent()) {
            Optional<File> jar = artifactRequester.requestFile(coordinate, dependencyTargetDirectory, ClassifierInformation.DEFAULT_JAR);
            jar.ifPresent(jarFile -> artifact.addFact((ArtifactFact)new ArtifactJar(jarFile.toPath())));
        }
        if (!artifact.getSourceFile().isPresent() && !artifact.getFile().isPresent()) {
            this.processingReporter.add(artifact, MessageType.MISSING_SOURCES, "Maven Artifact Coordinates present but non resolvable sources.");
        }
    }

    IArtifactRequester getArtifactRequester() {
        return this.sourcesRepositoryUrl != null ? ArtifactRequesterFactory.getArtifactRequester(this.optionalRepositorySystem, this.optionalMavenProject, this.optionalLegacySupport, this.basedir, this.httpClient, this.isMavenInstalled, this.sourcesRepositoryUrl) : ArtifactRequesterFactory.getArtifactRequester(this.optionalRepositorySystem, this.optionalMavenProject, this.optionalLegacySupport, this.basedir, this.httpClient, this.isMavenInstalled);
    }

    private boolean isIgnoredForSourceResolving(Artifact artifact) {
        return this.sourceResolvingBlacklist.stream().anyMatch(artifactSelector -> artifactSelector.matches(artifact));
    }

    private Predicate<Artifact> getFilterPredicate() {
        return artifact -> !artifact.getFlag("isProprietary");
    }
}

