/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.maven;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Optional;
import org.eclipse.sw360.antenna.http.HttpClient;
import org.eclipse.sw360.antenna.maven.ClassifierInformation;
import org.eclipse.sw360.antenna.maven.IArtifactRequester;
import org.eclipse.sw360.antenna.model.coordinates.Coordinate;
import org.eclipse.sw360.antenna.util.HttpHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequester
extends IArtifactRequester {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequester.class);
    private static final String GROUP_ID_PLACEHOLDER = "{groupId}";
    private static final String ARTIFACT_ID_PLACEHOLDER = "{artifactId}";
    private static final String VERSION_PLACEHOLDER = "{version}";
    private static final String MAVEN_CENTRAL_URL = "https://repo.maven.apache.org/maven2/{groupId}/{artifactId}/{version}/";
    private HttpHelper httpHelper;
    private Optional<URL> sourceRepositoryUrl;

    public HttpRequester(HttpClient httpClient, URL sourceRepositoryUrl) {
        this.httpHelper = new HttpHelper(httpClient);
        this.sourceRepositoryUrl = Optional.of(sourceRepositoryUrl);
    }

    public HttpRequester(HttpClient httpClient) {
        this.httpHelper = new HttpHelper(httpClient);
        this.sourceRepositoryUrl = Optional.empty();
    }

    @Override
    public Optional<File> requestFile(Coordinate mavenCoordinate, Path targetDirectory, ClassifierInformation classifierInformation) {
        String jarBaseName = this.getExpectedJarBaseName(mavenCoordinate, classifierInformation);
        File localJarFile = targetDirectory.resolve(jarBaseName).toFile();
        if (localJarFile.exists()) {
            LOGGER.debug("The file " + localJarFile + " already exists and won't be downloaded again");
            return Optional.of(localJarFile);
        }
        Optional<File> downloadedFile = this.downloadFileFromUserUrl(mavenCoordinate, targetDirectory, jarBaseName);
        if (!downloadedFile.isPresent()) {
            String mavenCentralJarUrl = this.getJarUrl(mavenCoordinate, jarBaseName, MAVEN_CENTRAL_URL);
            return this.tryFileDownload(mavenCentralJarUrl, targetDirectory, jarBaseName);
        }
        return downloadedFile;
    }

    private Optional<File> downloadFileFromUserUrl(Coordinate mavenCoordinate, Path targetDirectory, String jarBaseName) {
        if (this.sourceRepositoryUrl.isPresent()) {
            String jarUrl = this.convertToJarUrlTemplate(mavenCoordinate, jarBaseName, this.sourceRepositoryUrl.get().toString());
            return this.tryFileDownload(jarUrl, targetDirectory, jarBaseName);
        }
        return Optional.empty();
    }

    private String convertToJarUrlTemplate(Coordinate mavenCoordinate, String jarBaseName, String repoTemplate) {
        String enrichedTemplate = repoTemplate;
        enrichedTemplate = enrichedTemplate + (repoTemplate.endsWith("/") ? "" : "/");
        enrichedTemplate = enrichedTemplate + "{groupId}/{artifactId}/{version}/";
        return this.getJarUrl(mavenCoordinate, jarBaseName, enrichedTemplate);
    }

    private Optional<File> tryFileDownload(String jarUrl, Path targetDirectory, String jarBaseName) {
        try {
            LOGGER.debug("HttpRequester with download path " + jarUrl);
            return Optional.ofNullable(this.httpHelper.downloadFile(jarUrl, targetDirectory, jarBaseName));
        }
        catch (IOException e) {
            LOGGER.warn("Failed to find jar: ", (Throwable)e);
            return Optional.empty();
        }
    }

    private String getJarUrl(Coordinate mavenCoordinate, String remoteFileName, String repoTemplate) {
        String repo = repoTemplate.replace(GROUP_ID_PLACEHOLDER, mavenCoordinate.getNamespace().replace('.', '/')).replace(ARTIFACT_ID_PLACEHOLDER, mavenCoordinate.getName()).replace(VERSION_PLACEHOLDER, mavenCoordinate.getVersion());
        return repo + remoteFileName;
    }
}

