/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.maven;

import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.eclipse.sw360.antenna.api.exceptions.ExecutionException;
import org.eclipse.sw360.antenna.maven.ClassifierInformation;
import org.eclipse.sw360.antenna.maven.IArtifactRequester;
import org.eclipse.sw360.antenna.model.coordinates.Coordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenInvokerRequester
extends IArtifactRequester {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenInvokerRequester.class);
    public static final String POM_FILENAME = "pom.xml";
    private static final String MVN_ARG_GROUP_ID = "\"-DgroupId=%s\"";
    private static final String MVN_ARG_ARTIFACT_ID = "\"-DartifactId=%s\"";
    private static final String MVN_ARG_VERSION = "\"-Dversion=%s\"";
    private static final String MVN_ARG_DEST = "\"-Ddest=%s\"";
    private static final String MVN_ARG_CLASSIFIER = "\"-Dclassifier=%s\"";
    private static final String MVN_ARG_REPOS = "\"-DremoteRepositories=%s\"";
    private static final String MVN_DOWNLOAD_CMD = "dependency:get --quiet";
    private final File basedir;
    private DefaultInvoker defaultInvoker;
    private Optional<URL> sourceRepositoryUrl;

    public MavenInvokerRequester(File basedir) {
        this(basedir, new DefaultInvoker(), Optional.empty());
    }

    public MavenInvokerRequester(File basedir, URL sourceRepositoryUrl) {
        this(basedir, new DefaultInvoker(), Optional.of(sourceRepositoryUrl));
    }

    public MavenInvokerRequester(File basedir, DefaultInvoker defaultInvoker, Optional<URL> sourceRepositoryUrl) {
        this.basedir = basedir;
        this.defaultInvoker = defaultInvoker;
        if (System.getenv("M2_HOME") != null) {
            defaultInvoker.setMavenExecutable(new File(System.getenv("M2_HOME")));
        }
        this.sourceRepositoryUrl = sourceRepositoryUrl;
    }

    @Override
    public Optional<File> requestFile(Coordinate mavenCoordinate, Path targetDirectory, ClassifierInformation classifierInformation) {
        String jarType;
        File expectedJarFile = this.getExpectedJarFile(mavenCoordinate, targetDirectory, classifierInformation);
        if (expectedJarFile.exists()) {
            LOGGER.debug("The file " + expectedJarFile + " already exists and won't be downloaded again");
            return Optional.of(expectedJarFile);
        }
        LOGGER.debug("Requesting artifact with id " + mavenCoordinate.toString());
        boolean requestSuccessful = this.callMavenInvoker(mavenCoordinate, targetDirectory, classifierInformation.classifier);
        String string = jarType = classifierInformation.isSource ? "sources jar" : classifierInformation.classifier + " jar";
        if (!requestSuccessful) {
            LOGGER.warn("Failed to find " + jarType + ": Artifact " + mavenCoordinate.toString() + " not found in repo.");
            return Optional.empty();
        }
        if (!expectedJarFile.exists()) {
            LOGGER.warn("Failed to find " + jarType + ": Maven call succeeded but Artifact was not generated in the expected place.");
            return Optional.empty();
        }
        return Optional.of(this.getExpectedJarFile(mavenCoordinate, targetDirectory, classifierInformation));
    }

    private boolean callMavenInvoker(Coordinate mavenCoordinate, Path targetDirectory, String classifier) {
        List<String> mvnDownloadCmd = this.buildBasicMvnDownloadCmd(mavenCoordinate, targetDirectory);
        this.sourceRepositoryUrl.ifPresent(url -> mvnDownloadCmd.add(String.format(MVN_ARG_REPOS, url.toString())));
        if (!classifier.isEmpty()) {
            mvnDownloadCmd.add(String.format(MVN_ARG_CLASSIFIER, classifier));
        }
        InvocationRequest request = this.buildInvocationRequest(mvnDownloadCmd);
        return this.callMavenInvocationRequest(request);
    }

    private List<String> buildBasicMvnDownloadCmd(Coordinate mavenCoordinate, Path targetDirectory) {
        ArrayList<String> mvnDownloadCmd = new ArrayList<String>();
        mvnDownloadCmd.add(String.format(MVN_ARG_GROUP_ID, mavenCoordinate.getNamespace()));
        mvnDownloadCmd.add(String.format(MVN_ARG_ARTIFACT_ID, mavenCoordinate.getName()));
        mvnDownloadCmd.add(String.format(MVN_ARG_VERSION, mavenCoordinate.getVersion()));
        mvnDownloadCmd.add(String.format(MVN_ARG_DEST, targetDirectory));
        mvnDownloadCmd.add(MVN_DOWNLOAD_CMD);
        return mvnDownloadCmd;
    }

    protected File getPomFileFromContext() {
        return new File(this.basedir, POM_FILENAME);
    }

    private InvocationRequest buildInvocationRequest(List<String> mvnDownloadCmd) {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setPomFile(this.getPomFileFromContext());
        request.setGoals(mvnDownloadCmd);
        request.setOutputHandler(arg_0 -> ((Logger)LOGGER).debug(arg_0));
        return request;
    }

    private File getExpectedJarFile(Coordinate mavenCoordinate, Path targetDirectory, ClassifierInformation classifierInformation) {
        String jarBaseName = this.getExpectedJarBaseName(mavenCoordinate, classifierInformation);
        return new File(targetDirectory.toFile(), jarBaseName);
    }

    private boolean callMavenInvocationRequest(InvocationRequest request) {
        try {
            LOGGER.debug("Calling Maven Invoker with command " + String.join((CharSequence)", ", request.getGoals()));
            return this.defaultInvoker.execute(request).getExitCode() == 0;
        }
        catch (MavenInvocationException e) {
            throw new ExecutionException("Error when getting jar: " + (Object)((Object)e));
        }
    }
}

