/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.maven;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.repository.RepositorySystem;
import org.eclipse.sw360.antenna.api.exceptions.ExecutionException;
import org.eclipse.sw360.antenna.maven.ClassifierInformation;
import org.eclipse.sw360.antenna.maven.IArtifactRequester;
import org.eclipse.sw360.antenna.model.coordinates.Coordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenRuntimeRequester
extends IArtifactRequester {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenRuntimeRequester.class);
    private final RepositorySystem repositorySystem;
    private final ArtifactRepository localRepository;
    private final List<ArtifactRepository> remoteRepositories;

    public MavenRuntimeRequester(RepositorySystem repositorySystem, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, Optional<URL> sourcesRepositoryUrl) {
        if (sourcesRepositoryUrl.isPresent()) {
            ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>();
            MavenArtifactRepository userRepo = new MavenArtifactRepository("userRepo", sourcesRepositoryUrl.get().toString(), (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), new ArtifactRepositoryPolicy(), new ArtifactRepositoryPolicy());
            repositories.add((ArtifactRepository)userRepo);
            repositories.addAll(remoteRepositories);
            this.remoteRepositories = repositories;
        } else {
            this.remoteRepositories = remoteRepositories;
        }
        this.repositorySystem = repositorySystem;
        this.localRepository = localRepository;
        LOGGER.debug("Maven is running, using the MavenRuntimeRequester for artifact resolution");
    }

    @Override
    public Optional<File> requestFile(Coordinate mavenCoordinate, Path targetDirectory, ClassifierInformation classifierInformation) {
        if (classifierInformation.isSource) {
            return this.requestFile(mavenCoordinate, targetDirectory, "java-source", classifierInformation);
        }
        return this.requestFile(mavenCoordinate, targetDirectory, "jar", classifierInformation);
    }

    private Optional<File> requestFile(Coordinate mavenCoordinate, Path targetDirectory, String type, ClassifierInformation classifier) {
        String classifierExtension;
        String groupId = mavenCoordinate.getNamespace();
        String artifactId = mavenCoordinate.getName();
        String version = mavenCoordinate.getVersion();
        Artifact mvnArtifact = classifier.classifier.isEmpty() ? this.repositorySystem.createArtifact(groupId, artifactId, version, type) : this.repositorySystem.createArtifactWithClassifier(groupId, artifactId, version, type, classifier.classifier);
        ArtifactResolutionResult result = this.doArtifactRequest(mvnArtifact);
        String string = classifierExtension = classifier.classifier.isEmpty() ? "" : "-" + classifier.classifier;
        if (!this.wasSuccessful(result, mvnArtifact)) {
            LOGGER.error("Could not successfully fetch " + type + " for artifact=[" + groupId + ":" + artifactId + ":" + version + classifierExtension + "]");
            return Optional.empty();
        }
        File artifactFile = mvnArtifact.getFile();
        if (!artifactFile.exists()) {
            LOGGER.error("Fetching of File from repository was successful, but expected file=[" + artifactFile + "] does not exists");
            return Optional.empty();
        }
        File targetFile = targetDirectory.resolve(artifactFile.getName()).toFile();
        if (targetFile.exists()) {
            if (this.contentEquals(artifactFile, targetFile)) {
                LOGGER.debug("File " + targetFile + " was already fetched previously");
                return Optional.of(targetFile);
            }
            LOGGER.warn("File " + targetFile + " was already fetched previously, but is different to " + artifactFile + ", fall back to using the second");
            return Optional.of(artifactFile);
        }
        this.copyFile(artifactFile, targetFile);
        LOGGER.debug("successfully fetched " + type + " for artifact=[" + groupId + ":" + artifactId + ":" + version + classifierExtension + "]");
        return Optional.of(targetFile);
    }

    private ArtifactResolutionResult doArtifactRequest(Artifact mvnArtifact) {
        LOGGER.debug("Resolving maven artifact " + mvnArtifact.getArtifactId() + " in repositories " + this.remoteRepositories.stream().map(ArtifactRepository::getUrl).collect(Collectors.joining(", ")));
        ArtifactResolutionRequest artifactRequest = new ArtifactResolutionRequest();
        artifactRequest.setArtifact(mvnArtifact);
        artifactRequest.setResolveTransitively(false);
        artifactRequest.setRemoteRepositories(this.remoteRepositories);
        artifactRequest.setLocalRepository(this.localRepository);
        return this.repositorySystem.resolve(artifactRequest);
    }

    private boolean wasSuccessful(ArtifactResolutionResult result, Artifact mvnArtifact) {
        List resolutionErrors = result.getErrorArtifactExceptions();
        List missingArtifacts = result.getMissingArtifacts();
        return resolutionErrors.isEmpty() && (missingArtifacts == null || missingArtifacts.isEmpty() || !missingArtifacts.contains(mvnArtifact));
    }

    private boolean contentEquals(File artifactFile, File targetFile) {
        try {
            return Arrays.equals(Files.readAllBytes(artifactFile.toPath()), Files.readAllBytes(targetFile.toPath()));
        }
        catch (IOException e) {
            throw new ExecutionException("File content could not be compared: " + e.getMessage(), (Throwable)e);
        }
    }

    private void copyFile(File artifactFile, File targetFile) {
        try {
            Files.createDirectories(targetFile.getParentFile().toPath(), new FileAttribute[0]);
            Files.copy(artifactFile.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new ExecutionException("File could not be copied: " + e.getMessage(), (Throwable)e);
        }
    }
}

