/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.maven.workflow.analyzers;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.eclipse.sw360.antenna.api.exceptions.ExecutionException;
import org.eclipse.sw360.antenna.api.workflow.AbstractAnalyzer;
import org.eclipse.sw360.antenna.api.workflow.WorkflowStepResult;
import org.eclipse.sw360.antenna.maven.WrappedDependencyNodes;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.model.artifact.ArtifactFact;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactFile;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactMatchingMetadata;
import org.eclipse.sw360.antenna.model.artifact.facts.java.ArtifactPathnames;
import org.eclipse.sw360.antenna.model.coordinates.Coordinate;
import org.eclipse.sw360.antenna.model.xml.generated.MatchState;

public class MvnDependencyTreeAnalyzer
extends AbstractAnalyzer {
    public MvnDependencyTreeAnalyzer() {
        this.workflowStepOrder = (short)400;
    }

    public WorkflowStepResult yield() {
        Optional wrappedProjectsOptional = this.context.getGeneric(WrappedDependencyNodes.class);
        if (!wrappedProjectsOptional.isPresent()) {
            throw new ExecutionException("No Maven dependency tree was provided for analysis.");
        }
        List<DependencyNode> projectList = ((WrappedDependencyNodes)wrappedProjectsOptional.get()).getDependencyNodes();
        List collect = projectList.stream().map(this::getArtifactFromNode).collect(Collectors.toList());
        return new WorkflowStepResult(collect);
    }

    private Artifact getArtifactFromNode(DependencyNode node) {
        Artifact antennaArtifact = new Artifact(this.getName());
        String[] paths = node.getArtifact().getFile() != null ? new String[]{node.getArtifact().getFile().getPath()} : new String[]{};
        antennaArtifact.addCoordinate(this.getMavenCoordinate(node));
        if (node.getArtifact().getFile() != null) {
            antennaArtifact.addFact((ArtifactFact)new ArtifactFile(node.getArtifact().getFile().toPath()));
        }
        antennaArtifact.addFact((ArtifactFact)new ArtifactPathnames(paths));
        antennaArtifact.addFact((ArtifactFact)new ArtifactMatchingMetadata(MatchState.EXACT));
        return antennaArtifact;
    }

    private Coordinate getMavenCoordinate(DependencyNode node) {
        return new Coordinate("maven", node.getArtifact().getGroupId(), node.getArtifact().getArtifactId(), node.getArtifact().getVersion());
    }

    public String getName() {
        return "Maven dependency anaylzer";
    }
}

