/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.maven.workflow.processors.enricher;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.sw360.antenna.api.configuration.AntennaContext;
import org.eclipse.sw360.antenna.api.workflow.AbstractProcessor;
import org.eclipse.sw360.antenna.model.artifact.Artifact;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactFile;
import org.eclipse.sw360.antenna.model.coordinates.Coordinate;
import org.eclipse.sw360.antenna.model.reporting.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestResolver
extends AbstractProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManifestResolver.class);
    private Path basePath;

    public ManifestResolver() {
        this.workflowStepOrder = (short)900;
    }

    public void setAntennaContext(AntennaContext context) {
        super.setAntennaContext(context);
        this.basePath = context.getProject().getBasedir().toPath();
    }

    private void resolveManifest(Collection<Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            Optional pathname = artifact.askForGet(ArtifactFile.class);
            if (!pathname.isPresent() || !((Path)pathname.get()).toFile().exists()) continue;
            this.resolveManifest((Path)pathname.get(), artifact);
        }
    }

    private void resolveManifest(Path pathname, Artifact artifact) {
        LOGGER.debug("Resolving {}", (Object)pathname);
        try (JarFile jarFile = new JarFile(this.basePath.resolve(pathname).toFile());){
            this.setBundleCoordinates(artifact, jarFile.getManifest());
        }
        catch (IOException e) {
            LOGGER.error("Unable to process \"{}\" because of {}", (Object)pathname, (Object)e.getMessage());
            this.reporter.add(artifact, MessageType.PROCESSING_FAILURE, "An exeption occured while Manifest resolving:" + e.getMessage());
        }
    }

    private void setBundleCoordinates(Artifact artifact, Manifest manifest) {
        Optional<String> symbolicName = this.getAttribute(manifest, "Bundle-SymbolicName");
        Optional<String> version = this.getAttribute(manifest, "Bundle-Version");
        if (symbolicName.isPresent() || version.isPresent()) {
            artifact.addCoordinate(new Coordinate("p2", (String)symbolicName.orElse(null), (String)version.orElse(null)));
        }
    }

    private Optional<String> getAttribute(Manifest manifest, String attributeName) {
        return Optional.ofNullable(manifest).map(Manifest::getMainAttributes).flatMap(ma -> Optional.ofNullable(ma.getValue(attributeName))).map(av -> av.split(";")).map(av -> av[0]);
    }

    public Collection<Artifact> process(Collection<Artifact> artifacts) {
        LOGGER.debug("Resolve manifest...");
        this.resolveManifest(artifacts);
        LOGGER.debug("Resolve manifest... done");
        return artifacts;
    }
}

