/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.api.workflow;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.sw360.antenna.api.IProcessingReporter;
import org.eclipse.sw360.antenna.api.configuration.AntennaContext;
import org.eclipse.sw360.antenna.api.exceptions.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigurableWorkflowItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurableWorkflowItem.class);
    protected IProcessingReporter reporter;
    protected AntennaContext context;
    protected short workflowStepOrder = (short)1000;
    protected final short VALIDATOR_BASE_ORDER = (short)10000;

    public void setAntennaContext(AntennaContext context) {
        this.context = context;
        this.reporter = context.getProcessingReporter();
    }

    public String getWorkflowItemName() {
        return this.getClass().getName();
    }

    public void cleanup() {
    }

    public void overrideStepOrder(Short override) {
        if (override != null && override >= 0) {
            this.workflowStepOrder = override;
        }
    }

    public void configure() throws ConfigurationException {
        this.configure(Collections.emptyMap());
    }

    public short getWorkflowStepOrder() {
        return this.workflowStepOrder;
    }

    public void configure(Map<String, String> configMap) throws ConfigurationException {
    }

    public String getConfigValue(String key, Map<String, String> configMap) {
        return this.getConfigValue(key, configMap, null);
    }

    public String getConfigValue(String key, Map<String, String> configMap, String defaultValue) {
        String result = configMap.get(key);
        if (result == null && defaultValue != null) {
            return defaultValue;
        }
        if (result == null) {
            String error = String.format("%s misconfigured. \"%s\" not supplied", this.getWorkflowItemName(), key);
            LOGGER.error(error);
            throw new ConfigurationException(error);
        }
        return result;
    }

    public Boolean getBooleanConfigValue(String key, Map<String, String> configMap) {
        return "true".equals(this.getConfigValue(key, configMap, "false").toLowerCase());
    }

    public List<String> getCommaSeparatedConfigValue(String key, Map<String, String> configMap) {
        String configValue = this.getConfigValue(key, configMap, "");
        if ("".equals(configValue)) {
            return Collections.emptyList();
        }
        return Arrays.asList(configValue.split(","));
    }
}

