/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.api.workflow;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.sw360.antenna.api.IAttachable;
import org.eclipse.sw360.antenna.api.IEvaluationResult;
import org.eclipse.sw360.antenna.model.artifact.Artifact;

public class WorkflowStepResult {
    private final Set<Artifact> artifacts = new HashSet<Artifact>();
    private final boolean artifactsShouldBeAppended;
    private final Map<String, IAttachable> attachableMap = new HashMap<String, IAttachable>();
    private final List<String> additionalReportComments = new ArrayList<String>();
    private Map.Entry<String, Set<IEvaluationResult>> failCausingResults;

    public WorkflowStepResult(Collection<Artifact> artifacts, boolean artifactsShouldBeAppended) {
        this.artifacts.addAll(artifacts);
        this.artifactsShouldBeAppended = artifactsShouldBeAppended;
    }

    public WorkflowStepResult(Collection<Artifact> artifacts) {
        this.artifacts.addAll(artifacts);
        this.artifactsShouldBeAppended = false;
    }

    public Set<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public boolean attach(String key, IAttachable attachable) {
        return this.attachableMap.put(key, attachable) != null;
    }

    public void attachAll(Map<String, IAttachable> attachables) {
        this.attachableMap.putAll(attachables);
    }

    public Map<String, IAttachable> getAttachables() {
        return this.attachableMap;
    }

    public List<String> getAdditionalReportComments() {
        return this.additionalReportComments;
    }

    public boolean addAdditionalReportComment(String comment) {
        return this.additionalReportComments.add(comment);
    }

    public Map.Entry<String, Set<IEvaluationResult>> getFailCausingResults() {
        return this.failCausingResults;
    }

    public void addFailCausingResults(String workflowItemName, Set<IEvaluationResult> failCausingResults) {
        this.failCausingResults = new AbstractMap.SimpleEntry<String, Set<IEvaluationResult>>(workflowItemName, failCausingResults);
    }

    public boolean isArtifactsShouldBeAppended() {
        return this.artifactsShouldBeAppended;
    }

    public List<Artifact> getPotentialDuplicatesWith(WorkflowStepResult compareWsr) {
        return this.artifacts.stream().flatMap(artifact -> compareWsr.getArtifacts().stream().filter(artifact::isPotentialDuplicateOf)).collect(Collectors.toList());
    }
}

