/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.model.artifact;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.sw360.antenna.model.artifact.ArtifactFact;

public abstract class ArtifactFactWithPayload<T>
implements ArtifactFact {
    private final T payload;

    public ArtifactFactWithPayload(T payload) {
        this.payload = payload;
    }

    public T get() {
        return this.payload;
    }

    protected String getEmptyStringRepresentation() {
        return "EMPTY";
    }

    public ArtifactFact mergeWith(ArtifactFact resultWithPrecedence) {
        return resultWithPrecedence;
    }

    public String toString() {
        return Optional.ofNullable(this.payload).map(Objects::toString).orElse(this.getEmptyStringRepresentation());
    }

    @Override
    public String prettyPrint() {
        return "Set " + this.getFactContentName() + " to " + this.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.get() == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactFactWithPayload that = (ArtifactFactWithPayload)o;
        return Objects.equals(this.payload, that.payload);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.payload);
    }
}

