/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.model.artifact.facts;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.sw360.antenna.model.artifact.ArtifactFact;
import org.eclipse.sw360.antenna.model.artifact.ArtifactSelectorHelper;
import org.eclipse.sw360.antenna.model.artifact.facts.ArtifactIdentifier;
import org.eclipse.sw360.antenna.model.artifact.facts.java.ArtifactPathnames;

public class ArtifactFilename
implements ArtifactFact<ArtifactFilename>,
ArtifactIdentifier<ArtifactFilename> {
    private final Set<ArtifactFilenameEntry> artifactFilenameEntries = new HashSet<ArtifactFilenameEntry>();

    public ArtifactFilename(String filename) {
        this.artifactFilenameEntries.add(new ArtifactFilenameEntry(filename));
    }

    public ArtifactFilename(String filename, String hash) {
        this.artifactFilenameEntries.add(new ArtifactFilenameEntry(filename, hash));
    }

    public ArtifactFilename(String filename, String hash, String hashAlgorithm) {
        this.artifactFilenameEntries.add(new ArtifactFilenameEntry(filename, hash, hashAlgorithm));
    }

    public Set<ArtifactFilenameEntry> getArtifactFilenameEntries() {
        return Collections.unmodifiableSet(this.artifactFilenameEntries);
    }

    public List<String> getFilenames() {
        return this.artifactFilenameEntries.stream().map(ArtifactFilenameEntry::getFilename).collect(Collectors.toList());
    }

    public Optional<ArtifactFilenameEntry> getBestFilenameEntryGuess() {
        return this.artifactFilenameEntries.stream().filter(afe -> Objects.nonNull(afe.getFilename())).max(Comparator.comparing(afe -> afe.getFilename().length()));
    }

    @Override
    public ArtifactFilename mergeWith(ArtifactFilename resultWithPrecedence) {
        if (resultWithPrecedence != null) {
            this.artifactFilenameEntries.addAll(resultWithPrecedence.getArtifactFilenameEntries());
        }
        return this;
    }

    @Override
    public boolean matches(ArtifactIdentifier artifactIdentifier) {
        if (artifactIdentifier instanceof ArtifactFilename) {
            ArtifactFilename artifactFilename = (ArtifactFilename)artifactIdentifier;
            return this.artifactFilenameEntries.stream().anyMatch(artifactFilenameEntry -> artifactFilename.getArtifactFilenameEntries().stream().anyMatch(artifactFilenameEntry1 -> artifactFilenameEntry.matches((ArtifactFilenameEntry)artifactFilenameEntry1) || artifactFilenameEntry1.matches((ArtifactFilenameEntry)artifactFilenameEntry)));
        }
        if (artifactIdentifier instanceof ArtifactPathnames) {
            List artifactPathnames = (List)((ArtifactPathnames)artifactIdentifier).get();
            return artifactPathnames.stream().filter(Objects::nonNull).anyMatch(pn -> this.artifactFilenameEntries.stream().map(ArtifactFilenameEntry::getFilename).filter(Objects::nonNull).anyMatch(filename -> pn.equals(filename) || pn.endsWith("/" + filename) || pn.endsWith("\\" + filename)));
        }
        return false;
    }

    @Override
    public String getFactContentName() {
        return "Filename";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactFilename that = (ArtifactFilename)o;
        return Objects.equals(this.artifactFilenameEntries, that.artifactFilenameEntries);
    }

    public int hashCode() {
        return Objects.hash(this.artifactFilenameEntries);
    }

    @Override
    public boolean isEmpty() {
        return this.artifactFilenameEntries.stream().allMatch(ArtifactFilenameEntry::isEmpty);
    }

    @Override
    public String prettyPrint() {
        return "Set " + this.getFactContentName() + " to " + this.toString();
    }

    public String toString() {
        return this.artifactFilenameEntries.stream().map(Objects::toString).collect(Collectors.joining(",", "[", "]"));
    }

    public static class ArtifactFilenameEntry {
        private final String filename;
        private final String hash;
        private final String hashAlgorithm;

        public ArtifactFilenameEntry(String filename) {
            this.filename = this.sanitizeString(filename);
            this.hash = null;
            this.hashAlgorithm = "UNKNOWN";
        }

        public ArtifactFilenameEntry(String filename, String hash) {
            this.filename = this.sanitizeString(filename);
            this.hash = this.sanitizeString(hash);
            this.hashAlgorithm = "UNKNOWN";
        }

        public ArtifactFilenameEntry(String filename, String hash, String hashAlgorithm) {
            this.filename = this.sanitizeString(filename);
            this.hash = this.sanitizeString(hash);
            this.hashAlgorithm = hashAlgorithm;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getHash() {
            return this.hash;
        }

        public String getHashAlgorithm() {
            return this.hashAlgorithm;
        }

        private String sanitizeString(String input) {
            return Optional.ofNullable(input).map(String::trim).filter(string -> !string.isEmpty()).orElse(null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArtifactFilenameEntry that = (ArtifactFilenameEntry)o;
            return Objects.equals(this.filename, that.filename) && Objects.equals(this.hash, that.hash) && Objects.equals(this.hashAlgorithm, that.hashAlgorithm);
        }

        public boolean matches(ArtifactFilenameEntry artifactFilenameEntry) {
            return ArtifactSelectorHelper.compareStringsAsWildcard(this.filename, artifactFilenameEntry.filename) && ArtifactSelectorHelper.compareStringsAsWildcard(this.hash, artifactFilenameEntry.hash) && (this.hash == null || Objects.equals(this.hashAlgorithm, artifactFilenameEntry.hashAlgorithm));
        }

        public int hashCode() {
            return Objects.hash(this.filename, this.hash, this.hashAlgorithm);
        }

        public boolean isEmpty() {
            return this.filename == null && this.hash == null;
        }

        public String toString() {
            return this.filename + " (hash='" + this.hash + '\'' + ", hashAlgorithm='" + this.hashAlgorithm + '\'' + ')';
        }
    }
}

