/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sw360.antenna.model.license;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.sw360.antenna.model.license.LicenseInformation;

public class License
implements LicenseInformation {
    private static final String THREAT_GROUP_KEY = "threatGroup";
    private static final String CLASSIFICATION_KEY = "classification";
    private String id;
    private String commonName;
    private String text;
    private Map<String, String> properties;

    public License() {
        this(null, null, null, null);
    }

    public License(String id) {
        this(id, null, null, null);
    }

    public License(String id, String commonName, String text) {
        this(id, commonName, text, null);
    }

    public License(String id, String commonName, String text, Map<String, String> properties) {
        this.id = id != null ? id : "";
        this.commonName = commonName != null ? commonName : "";
        this.text = text != null ? text : "";
        this.properties = new HashMap<String, String>();
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id != null ? id : "";
    }

    public String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName != null ? commonName : "";
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text != null ? text : "";
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = new HashMap<String, String>();
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    public void setProperty(String key, String property) {
        if (key != null) {
            this.properties.put(key, property);
        }
    }

    public Optional<String> getProperty(String key) {
        return Optional.ofNullable(key != null ? this.properties.get(key) : null);
    }

    public void setThreatGroup(String value) {
        this.setProperty(THREAT_GROUP_KEY, value);
    }

    public Optional<String> getThreatGroup() {
        return this.getProperty(THREAT_GROUP_KEY);
    }

    public void setClassification(String value) {
        this.setProperty(CLASSIFICATION_KEY, value);
    }

    public Optional<String> getClassification() {
        return this.getProperty(CLASSIFICATION_KEY);
    }

    @Override
    public String evaluate() {
        return this.getId();
    }

    @Override
    public boolean isEmpty() {
        return "".equals(this.id.trim());
    }

    @Override
    public Collection<License> getLicenses() {
        return Collections.singletonList(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        License license = (License)o;
        return Objects.equals(this.id, license.id) && Objects.equals(this.commonName, license.commonName) && Objects.equals(this.text, license.text) && Objects.equals(this.properties, license.properties);
    }

    public boolean equalLicense(License license) {
        return Objects.equals(this.getId(), license.getId());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.commonName, this.text, this.properties);
    }

    public String toString() {
        return this.evaluate();
    }
}

